/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.cache.ParsingResultCache;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngine;
import org.apache.shardingsphere.core.parse.old.lexer.LexerEngineFactory;
import org.apache.shardingsphere.core.parse.old.parser.sql.SQLParserFactory;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class SQLParsingEngine {
    private final DatabaseType dbType;
    private final String sql;
    private final ShardingRule shardingRule;
    private final ShardingTableMetaData shardingTableMetaData;
    private final ParsingResultCache parsingResultCache;

    public SQLStatement parse(boolean useCache) {
        Optional<SQLStatement> cachedSQLStatement = this.getSQLStatementFromCache(useCache);
        if (cachedSQLStatement.isPresent()) {
            return (SQLStatement)cachedSQLStatement.get();
        }
        LexerEngine lexerEngine = LexerEngineFactory.newInstance(this.dbType, this.sql);
        SQLStatement result = SQLParserFactory.newInstance(this.dbType, this.shardingRule, lexerEngine, this.shardingTableMetaData, this.sql).parse();
        if (useCache) {
            this.parsingResultCache.put(this.sql, result);
        }
        return result;
    }

    private Optional<SQLStatement> getSQLStatementFromCache(boolean useCache) {
        return useCache ? Optional.fromNullable((Object)this.parsingResultCache.getSQLStatement(this.sql)) : Optional.absent();
    }

    @ConstructorProperties(value={"dbType", "sql", "shardingRule", "shardingTableMetaData", "parsingResultCache"})
    public SQLParsingEngine(DatabaseType dbType, String sql, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData, ParsingResultCache parsingResultCache) {
        this.dbType = dbType;
        this.sql = sql;
        this.shardingRule = shardingRule;
        this.shardingTableMetaData = shardingTableMetaData;
        this.parsingResultCache = parsingResultCache;
    }
}

