/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr;

import java.util.Collection;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.extractor.SQLSegmentsExtractorEngine;
import org.apache.shardingsphere.core.parse.antlr.filler.SQLStatementFillerEngine;
import org.apache.shardingsphere.core.parse.antlr.optimizer.SQLStatementOptimizerEngine;
import org.apache.shardingsphere.core.parse.antlr.parser.SQLAST;
import org.apache.shardingsphere.core.parse.antlr.parser.SQLParserEngine;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.EncryptParsingRuleRegistry;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.ParsingRuleRegistry;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.ShardingParsingRuleRegistry;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.statement.SQLStatementRule;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.SQLSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.GeneralSQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.old.parser.sql.SQLParser;
import org.apache.shardingsphere.core.rule.BaseRule;
import org.apache.shardingsphere.core.rule.EncryptRule;

public final class AntlrParsingEngine
implements SQLParser {
    private final ParsingRuleRegistry parsingRuleRegistry;
    private final SQLParserEngine parserEngine;
    private final SQLSegmentsExtractorEngine extractorEngine;
    private final SQLStatementFillerEngine fillerEngine;
    private final SQLStatementOptimizerEngine optimizerEngine;

    public AntlrParsingEngine(DatabaseType databaseType, String sql, BaseRule rule, ShardingTableMetaData shardingTableMetaData) {
        this.parsingRuleRegistry = rule instanceof EncryptRule ? EncryptParsingRuleRegistry.getInstance() : ShardingParsingRuleRegistry.getInstance();
        this.parserEngine = new SQLParserEngine(this.parsingRuleRegistry, databaseType, sql);
        this.extractorEngine = new SQLSegmentsExtractorEngine();
        this.fillerEngine = new SQLStatementFillerEngine(this.parsingRuleRegistry, databaseType, sql, rule, shardingTableMetaData);
        this.optimizerEngine = new SQLStatementOptimizerEngine(shardingTableMetaData);
    }

    @Override
    public SQLStatement parse() {
        SQLAST ast = this.parserEngine.parse();
        if (!ast.getSQLStatementRule().isPresent() && this.parsingRuleRegistry instanceof EncryptParsingRuleRegistry) {
            return new GeneralSQLStatement();
        }
        Collection<SQLSegment> sqlSegments = this.extractorEngine.extract(ast);
        SQLStatement result = this.fillerEngine.fill(sqlSegments, (SQLStatementRule)ast.getSQLStatementRule().get());
        this.optimizerEngine.optimize((SQLStatementRule)ast.getSQLStatementRule().get(), result);
        return result;
    }
}

