/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.common.column;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.ColumnSegment;

public final class ColumnExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<ColumnSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> columnNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.COLUMN_NAME);
        if (columnNode.isPresent()) {
            return Optional.of((Object)this.getColumnSegment((ParserRuleContext)columnNode.get()));
        }
        return Optional.absent();
    }

    private ColumnSegment getColumnSegment(ParserRuleContext columnNode) {
        if (1 == columnNode.getChildCount()) {
            return new ColumnSegment(columnNode.getChild(0).getText(), columnNode.getStart().getStartIndex(), columnNode.getStop().getStopIndex());
        }
        Preconditions.checkState((3 == columnNode.getChildCount() ? 1 : 0) != 0);
        return new ColumnSegment(columnNode.getChild(2).getText(), columnNode.getChild(0).getText(), columnNode.getStart().getStartIndex(), columnNode.getStop().getStopIndex());
    }
}

