/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.common.table;

import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import java.util.List;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.parse.antlr.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.common.TableSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.token.TableToken;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;

public final class TableNameExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<TableSegment> extract(ParserRuleContext ancestorNode) {
        int schemaNameLength;
        Optional schemaName;
        String tableName;
        Optional<ParserRuleContext> tableNameNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.TABLE_NAME);
        if (!tableNameNode.isPresent()) {
            return Optional.absent();
        }
        String nodeText = ((ParserRuleContext)tableNameNode.get()).getText();
        if (nodeText.contains(Symbol.DOT.getLiterals())) {
            List nodeTextSegments = Splitter.on((String)Symbol.DOT.getLiterals()).splitToList((CharSequence)nodeText);
            tableName = (String)nodeTextSegments.get(nodeTextSegments.size() - 1);
            schemaName = Optional.of(nodeTextSegments.get(nodeTextSegments.size() - 2));
            schemaNameLength = nodeText.lastIndexOf(Symbol.DOT.getLiterals()) + 1;
        } else {
            tableName = nodeText;
            schemaName = Optional.absent();
            schemaNameLength = 0;
        }
        return Optional.of((Object)new TableSegment(this.getTableToken((ParserRuleContext)tableNameNode.get(), tableName, schemaNameLength), (String)schemaName.orNull(), (String)this.getTableAlias((ParserRuleContext)tableNameNode.get()).orNull()));
    }

    private TableToken getTableToken(ParserRuleContext tableNameNode, String tableName, int schemaNameLength) {
        return new TableToken(tableNameNode.getStart().getStartIndex(), tableName, QuoteCharacter.getQuoteCharacter(tableName), schemaNameLength);
    }

    private Optional<String> getTableAlias(ParserRuleContext tableNameNode) {
        Optional<ParserRuleContext> aliasNode = ExtractorUtils.findFirstChildNode(tableNameNode.getParent(), RuleName.ALIAS);
        return aliasNode.isPresent() ? Optional.of((Object)((ParserRuleContext)aliasNode.get()).getText()) : Optional.absent();
    }
}

