/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.ddl.table;

import com.google.common.base.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.common.table.TableNameExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.common.TableSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.ddl.table.RenameTableSegment;

public final class RenameTableExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<RenameTableSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> renameTableNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.RENAME_TABLE_SPECIFICATION);
        if (!renameTableNode.isPresent()) {
            return Optional.absent();
        }
        Optional<TableSegment> tableSegment = new TableNameExtractor().extract((ParserRuleContext)renameTableNode.get());
        if (tableSegment.isPresent()) {
            return Optional.of((Object)new RenameTableSegment(((TableSegment)tableSegment.get()).getName()));
        }
        return Optional.absent();
    }
}

