/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.common.column.ColumnExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.ExpressionExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.CommonExpressionSegment;

public final class AssignmentExtractor {
    private final ColumnExtractor columnExtractor = new ColumnExtractor();
    private final ExpressionExtractor expressionExtractor = new ExpressionExtractor();

    public Optional<AssignmentSegment> extract(Map<ParserRuleContext, Integer> placeholderIndexes, ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> assignmentNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.ASSIGNMENT);
        if (!assignmentNode.isPresent()) {
            return Optional.absent();
        }
        Optional<ColumnSegment> columnSegment = this.columnExtractor.extract((ParserRuleContext)((ParserRuleContext)assignmentNode.get()).getChild(0));
        Preconditions.checkState((boolean)columnSegment.isPresent());
        CommonExpressionSegment expressionSegment = this.expressionExtractor.extractCommonExpressionSegment(placeholderIndexes, (ParserRuleContext)((ParserRuleContext)assignmentNode.get()).getChild(2));
        return Optional.of((Object)new AssignmentSegment((ColumnSegment)columnSegment.get(), expressionSegment));
    }
}

