/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.common.column.ColumnExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.select.SubqueryExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.CommonExpressionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.FunctionExpressionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.PropertyExpressionSegment;
import org.apache.shardingsphere.core.util.NumberUtil;

public final class ExpressionExtractor {
    public Optional<? extends ExpressionSegment> extract(Map<ParserRuleContext, Integer> placeholderIndexes, ParserRuleContext expressionNode) {
        Optional<ParserRuleContext> subqueryNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.SUBQUERY);
        return subqueryNode.isPresent() ? new SubqueryExtractor().extract((ParserRuleContext)subqueryNode.get()) : Optional.of((Object)this.extractExpression(placeholderIndexes, expressionNode));
    }

    private ExpressionSegment extractExpression(Map<ParserRuleContext, Integer> placeholderIndexes, ParserRuleContext expressionNode) {
        Optional<ParserRuleContext> functionNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.FUNCTION_CALL);
        if (functionNode.isPresent()) {
            return this.extractFunctionExpressionSegment((ParserRuleContext)functionNode.get());
        }
        if (RuleName.COLUMN_NAME.getName().equals(expressionNode.getChild(0).getClass().getSimpleName())) {
            return this.extractPropertyExpressionSegment(expressionNode);
        }
        return this.extractCommonExpressionSegment(placeholderIndexes, expressionNode);
    }

    private ExpressionSegment extractFunctionExpressionSegment(ParserRuleContext functionNode) {
        return new FunctionExpressionSegment(functionNode.getStart().getStartIndex(), functionNode.getStop().getStopIndex(), functionNode.getChild(0).getText(), ((TerminalNode)functionNode.getChild(1)).getSymbol().getStartIndex(), functionNode.getStop().getStopIndex(), -1);
    }

    private ExpressionSegment extractPropertyExpressionSegment(ParserRuleContext expressionNode) {
        ParserRuleContext columnNode = (ParserRuleContext)expressionNode.getChild(0);
        Optional<ColumnSegment> columnSegment = new ColumnExtractor().extract(columnNode);
        Preconditions.checkState((boolean)columnSegment.isPresent());
        return new PropertyExpressionSegment(columnNode.getStart().getStartIndex(), columnNode.getStop().getStopIndex(), ((ColumnSegment)columnSegment.get()).getName(), (String)((ColumnSegment)columnSegment.get()).getOwner().orNull());
    }

    public CommonExpressionSegment extractCommonExpressionSegment(Map<ParserRuleContext, Integer> placeholderIndexes, ParserRuleContext expressionNode) {
        Optional<ParserRuleContext> stringNode;
        CommonExpressionSegment result = new CommonExpressionSegment(expressionNode.getStart().getStartIndex(), expressionNode.getStop().getStopIndex());
        Optional<ParserRuleContext> questionNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.QUESTION);
        if (questionNode.isPresent()) {
            Integer index = placeholderIndexes.get(questionNode.get());
            result.setPlaceholderIndex(index);
            return result;
        }
        Optional<ParserRuleContext> bitExprNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.BIT_EXPR);
        if (bitExprNode.isPresent() && 1 != ((ParserRuleContext)bitExprNode.get()).getChildCount()) {
            return result;
        }
        Optional<ParserRuleContext> numberNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.NUMBER);
        if (numberNode.isPresent()) {
            result.setLiterals(NumberUtil.getExactlyNumber((String)((ParserRuleContext)numberNode.get()).getText(), (int)10));
        }
        if ((stringNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.STRING)).isPresent()) {
            String text = ((ParserRuleContext)stringNode.get()).getText();
            result.setLiterals(text.substring(1, text.length() - 1));
        }
        return result;
    }
}

