/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.constant.ShardingOperator;
import org.apache.shardingsphere.core.parse.antlr.constant.LogicalOperator;
import org.apache.shardingsphere.core.parse.antlr.constant.Paren;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.common.column.ColumnExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.ExpressionExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.condition.AndConditionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.condition.ConditionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.condition.OrConditionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.BetweenValueExpressionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.CompareValueExpressionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.InValueExpressionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.SQLRightValueExpressionSegment;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;

public final class PredicateExtractor {
    private final ExpressionExtractor expressionExtractor = new ExpressionExtractor();

    public Optional<OrConditionSegment> extract(Map<ParserRuleContext, Integer> placeholderIndexes, ParserRuleContext exprNode) {
        return this.extractConditionInternal(placeholderIndexes, exprNode);
    }

    private Optional<OrConditionSegment> extractConditionInternal(Map<ParserRuleContext, Integer> placeholderIndexes, ParserRuleContext exprNode) {
        int index = -1;
        for (int i = 0; i < exprNode.getChildCount(); ++i) {
            if (!LogicalOperator.isLogicalOperator(exprNode.getChild(i).getText())) continue;
            index = i;
            break;
        }
        if (index > 0) {
            Optional<OrConditionSegment> leftOrCondition = this.extractConditionInternal(placeholderIndexes, (ParserRuleContext)exprNode.getChild(index - 1));
            Optional<OrConditionSegment> rightOrCondition = this.extractConditionInternal(placeholderIndexes, (ParserRuleContext)exprNode.getChild(index + 1));
            if (leftOrCondition.isPresent() && rightOrCondition.isPresent()) {
                return Optional.of((Object)this.mergeCondition((OrConditionSegment)leftOrCondition.get(), (OrConditionSegment)rightOrCondition.get(), exprNode.getChild(index).getText()));
            }
            return leftOrCondition.isPresent() ? leftOrCondition : rightOrCondition;
        }
        return this.extractConditionForParen(placeholderIndexes, exprNode);
    }

    private OrConditionSegment mergeCondition(OrConditionSegment leftOrCondition, OrConditionSegment rightOrCondition, String operator) {
        if (LogicalOperator.isOrOperator(operator)) {
            leftOrCondition.getAndConditions().addAll(rightOrCondition.getAndConditions());
            return leftOrCondition;
        }
        OrConditionSegment result = new OrConditionSegment();
        for (AndConditionSegment each : leftOrCondition.getAndConditions()) {
            for (AndConditionSegment eachRightOr : rightOrCondition.getAndConditions()) {
                AndConditionSegment tempList = new AndConditionSegment();
                tempList.getConditions().addAll(each.getConditions());
                tempList.getConditions().addAll(eachRightOr.getConditions());
                result.getAndConditions().add(tempList);
            }
        }
        return result;
    }

    private Optional<OrConditionSegment> extractConditionForParen(Map<ParserRuleContext, Integer> placeholderIndexes, ParserRuleContext exprNode) {
        int index = -1;
        for (int i = 0; i < exprNode.getChildCount(); ++i) {
            if (!Paren.isLeftParen(exprNode.getChild(i).getText())) continue;
            index = i;
            break;
        }
        if (-1 != index) {
            Preconditions.checkState((boolean)Paren.match(exprNode.getChild(index).getText(), exprNode.getChild(index + 2).getText()), (Object)"Missing right paren.");
            if (RuleName.EXPR.getName().equals(exprNode.getChild(index + 1).getClass().getSimpleName())) {
                return this.extractConditionInternal(placeholderIndexes, (ParserRuleContext)exprNode.getChild(index + 1));
            }
            return Optional.absent();
        }
        Optional<ConditionSegment> condition = this.buildCondition(placeholderIndexes, exprNode);
        if (!condition.isPresent()) {
            return Optional.absent();
        }
        OrConditionSegment result = new OrConditionSegment();
        AndConditionSegment newAndCondition = new AndConditionSegment();
        newAndCondition.getConditions().add((ConditionSegment)condition.get());
        result.getAndConditions().add(newAndCondition);
        return Optional.of((Object)result);
    }

    private Optional<ConditionSegment> buildCondition(Map<ParserRuleContext, Integer> placeholderIndexes, ParserRuleContext exprNode) {
        Optional<ConditionSegment> result = this.buildCompareCondition(placeholderIndexes, exprNode);
        if (result.isPresent()) {
            return result;
        }
        Optional<ParserRuleContext> predicateNode = ExtractorUtils.findFirstChildNode(exprNode, RuleName.PREDICATE);
        if (!predicateNode.isPresent()) {
            return Optional.absent();
        }
        if (1 != ((ParserRuleContext)predicateNode.get()).getParent().getChildCount()) {
            return Optional.absent();
        }
        if (5 == ((ParserRuleContext)predicateNode.get()).getChildCount() && DefaultKeyword.BETWEEN.name().equalsIgnoreCase(((ParserRuleContext)predicateNode.get()).getChild(1).getText()) && (result = this.buildBetweenCondition(placeholderIndexes, (ParserRuleContext)predicateNode.get())).isPresent()) {
            return result;
        }
        if (5 <= ((ParserRuleContext)predicateNode.get()).getChildCount() && DefaultKeyword.IN.name().equalsIgnoreCase(((ParserRuleContext)predicateNode.get()).getChild(1).getText()) && (result = this.buildInCondition(placeholderIndexes, (ParserRuleContext)predicateNode.get())).isPresent()) {
            return result;
        }
        return Optional.absent();
    }

    private Optional<ConditionSegment> buildCompareCondition(Map<ParserRuleContext, Integer> placeholderIndexes, ParserRuleContext exprNode) {
        Optional<ParserRuleContext> comparisionNode = ExtractorUtils.findFirstChildNode(exprNode, RuleName.COMPARISON_OPERATOR);
        if (!comparisionNode.isPresent()) {
            return Optional.absent();
        }
        ParserRuleContext predicateNode = ((ParserRuleContext)comparisionNode.get()).getParent();
        Optional<ParserRuleContext> leftNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)predicateNode.getChild(0), RuleName.COLUMN_NAME);
        Optional<ParserRuleContext> rightNode = ExtractorUtils.findFirstChildNode((ParserRuleContext)predicateNode.getChild(2), RuleName.COLUMN_NAME);
        if (!leftNode.isPresent() && !rightNode.isPresent()) {
            return Optional.absent();
        }
        if (leftNode.isPresent() && rightNode.isPresent()) {
            Optional<ColumnSegment> leftColumn = this.buildColumn((ParserRuleContext)leftNode.get());
            Optional<ColumnSegment> rightColumn = this.buildColumn((ParserRuleContext)rightNode.get());
            Preconditions.checkState((leftColumn.isPresent() && rightColumn.isPresent() ? 1 : 0) != 0);
            return Optional.of((Object)new ConditionSegment((ColumnSegment)leftColumn.get(), ((ParserRuleContext)comparisionNode.get()).getText(), (SQLRightValueExpressionSegment)rightColumn.get(), predicateNode.getStop().getStopIndex()));
        }
        Optional<ColumnSegment> column = this.buildColumn(exprNode);
        Preconditions.checkState((boolean)column.isPresent());
        ParserRuleContext valueNode = leftNode.isPresent() ? (ParserRuleContext)((ParserRuleContext)comparisionNode.get()).parent.getChild(2) : (ParserRuleContext)((ParserRuleContext)comparisionNode.get()).parent.getChild(0);
        Optional<? extends ExpressionSegment> sqlExpression = this.expressionExtractor.extract(placeholderIndexes, valueNode);
        return sqlExpression.isPresent() ? Optional.of((Object)new ConditionSegment((ColumnSegment)column.get(), ((ParserRuleContext)comparisionNode.get()).getText(), new CompareValueExpressionSegment((ExpressionSegment)sqlExpression.get(), ((ParserRuleContext)comparisionNode.get()).getText()), predicateNode.getStop().getStopIndex())) : Optional.absent();
    }

    private Optional<ConditionSegment> buildBetweenCondition(Map<ParserRuleContext, Integer> placeholderIndexes, ParserRuleContext predicateNode) {
        Optional<ColumnSegment> column = this.buildColumn((ParserRuleContext)predicateNode.getChild(0));
        if (!column.isPresent()) {
            return Optional.absent();
        }
        Optional<? extends ExpressionSegment> beginSQLExpression = this.expressionExtractor.extract(placeholderIndexes, (ParserRuleContext)predicateNode.getChild(2));
        Optional<? extends ExpressionSegment> endSQLExpression = this.expressionExtractor.extract(placeholderIndexes, (ParserRuleContext)predicateNode.getChild(4));
        if (beginSQLExpression.isPresent() && endSQLExpression.isPresent()) {
            return Optional.of((Object)new ConditionSegment((ColumnSegment)column.get(), ShardingOperator.BETWEEN.name(), new BetweenValueExpressionSegment((ExpressionSegment)beginSQLExpression.get(), (ExpressionSegment)endSQLExpression.get()), predicateNode.getStop().getStopIndex()));
        }
        return Optional.absent();
    }

    private Optional<ConditionSegment> buildInCondition(Map<ParserRuleContext, Integer> placeholderIndexes, ParserRuleContext predicateNode) {
        Optional<ColumnSegment> column = this.buildColumn((ParserRuleContext)predicateNode.getChild(0));
        if (!column.isPresent()) {
            return Optional.absent();
        }
        LinkedList<Object> sqlExpressions = new LinkedList<Object>();
        for (int i = 3; i < predicateNode.getChildCount(); ++i) {
            if (!RuleName.EXPR.getName().equals(predicateNode.getChild(i).getClass().getSimpleName())) continue;
            Optional<? extends ExpressionSegment> expression = this.expressionExtractor.extract(placeholderIndexes, (ParserRuleContext)predicateNode.getChild(i));
            if (!expression.isPresent()) {
                sqlExpressions.clear();
                break;
            }
            sqlExpressions.add(expression.get());
        }
        if (!sqlExpressions.isEmpty()) {
            InValueExpressionSegment inExpressionSegment = new InValueExpressionSegment();
            inExpressionSegment.getSqlExpressions().addAll(sqlExpressions);
            return Optional.of((Object)new ConditionSegment((ColumnSegment)column.get(), ShardingOperator.IN.name(), inExpressionSegment, predicateNode.getStop().getStopIndex()));
        }
        return Optional.absent();
    }

    private Optional<ColumnSegment> buildColumn(ParserRuleContext parentNode) {
        return new ColumnExtractor().extract(parentNode);
    }
}

