/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.AssignmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.assignment.SetAssignmentsSegment;

public final class SetAssignmentsExtractor
implements OptionalSQLSegmentExtractor {
    private final AssignmentExtractor assignmentExtractor = new AssignmentExtractor();

    public Optional<SetAssignmentsSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> setAssignmentsClauseNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.SET_ASSIGNMENTS_CLAUSE);
        if (!setAssignmentsClauseNode.isPresent()) {
            return Optional.absent();
        }
        LinkedList<AssignmentSegment> assignmentSegments = new LinkedList<AssignmentSegment>();
        Map<ParserRuleContext, Integer> placeholderIndexes = this.getPlaceholderIndexes(ancestorNode);
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.ASSIGNMENT)) {
            Optional<AssignmentSegment> assignmentSegment = this.assignmentExtractor.extract(placeholderIndexes, each);
            if (!assignmentSegment.isPresent()) continue;
            assignmentSegments.add((AssignmentSegment)assignmentSegment.get());
        }
        return Optional.of((Object)new SetAssignmentsSegment(((ParserRuleContext)setAssignmentsClauseNode.get()).getStart().getStartIndex(), assignmentSegments));
    }

    private Map<ParserRuleContext, Integer> getPlaceholderIndexes(ParserRuleContext rootNode) {
        Collection<ParserRuleContext> placeholderNodes = ExtractorUtils.getAllDescendantNodes(rootNode, RuleName.QUESTION);
        HashMap<ParserRuleContext, Integer> result = new HashMap<ParserRuleContext, Integer>(placeholderNodes.size(), 1.0f);
        int index = 0;
        for (ParserRuleContext each : placeholderNodes) {
            result.put(each, index++);
        }
        return result;
    }
}

