/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.insert;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.common.column.ColumnExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.InsertColumnsSegment;

public final class InsertColumnsExtractor
implements OptionalSQLSegmentExtractor {
    private final ColumnExtractor columnExtractor = new ColumnExtractor();

    public Optional<InsertColumnsSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> insertValuesClause = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.INSERT_VALUES_CLAUSE);
        return insertValuesClause.isPresent() ? Optional.of((Object)new InsertColumnsSegment(((ParserRuleContext)insertValuesClause.get()).getStart().getStartIndex(), this.extractColumns((ParserRuleContext)insertValuesClause.get()))) : Optional.absent();
    }

    private Collection<ColumnSegment> extractColumns(ParserRuleContext ancestorNode) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.COLUMN_NAME)) {
            Optional<ColumnSegment> columnSegment = this.columnExtractor.extract(each);
            if (!columnSegment.isPresent()) continue;
            result.add((ColumnSegment)columnSegment.get());
        }
        return result;
    }
}

