/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.insert;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.CollectionSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.ExpressionExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.InsertValuesSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.CommonExpressionSegment;

public final class InsertValuesExtractor
implements CollectionSQLSegmentExtractor {
    private final ExpressionExtractor expressionExtractor = new ExpressionExtractor();

    public Collection<InsertValuesSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> insertValuesClauseNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.INSERT_VALUES_CLAUSE);
        if (!insertValuesClauseNode.isPresent()) {
            return Collections.emptyList();
        }
        LinkedList<InsertValuesSegment> result = new LinkedList<InsertValuesSegment>();
        Map<ParserRuleContext, Integer> placeholderIndexes = this.getPlaceholderIndexes(ancestorNode);
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes((ParserRuleContext)insertValuesClauseNode.get(), RuleName.ASSIGNMENT_VALUES)) {
            result.add(new InsertValuesSegment(this.extractCommonExpressionSegments(each, placeholderIndexes)));
        }
        return result;
    }

    private Map<ParserRuleContext, Integer> getPlaceholderIndexes(ParserRuleContext rootNode) {
        Collection<ParserRuleContext> placeholderNodes = ExtractorUtils.getAllDescendantNodes(rootNode, RuleName.QUESTION);
        HashMap<ParserRuleContext, Integer> result = new HashMap<ParserRuleContext, Integer>(placeholderNodes.size(), 1.0f);
        int index = 0;
        for (ParserRuleContext each : placeholderNodes) {
            result.put(each, index++);
        }
        return result;
    }

    private Collection<CommonExpressionSegment> extractCommonExpressionSegments(ParserRuleContext assignmentValuesNode, Map<ParserRuleContext, Integer> placeholderIndexes) {
        LinkedList<CommonExpressionSegment> result = new LinkedList<CommonExpressionSegment>();
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(assignmentValuesNode, RuleName.ASSIGNMENT_VALUE)) {
            result.add(this.expressionExtractor.extractCommonExpressionSegment(placeholderIndexes, each));
        }
        return result;
    }
}

