/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.insert;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.common.column.ColumnExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.OnDuplicateKeyColumnsSegment;

public final class OnDuplicateKeyColumnsExtractor
implements OptionalSQLSegmentExtractor {
    private final ColumnExtractor columnExtractor = new ColumnExtractor();

    public Optional<OnDuplicateKeyColumnsSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> onDuplicateKeyClauseNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.ON_DUPLICATE_KEY_CLAUSE);
        if (!onDuplicateKeyClauseNode.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)new OnDuplicateKeyColumnsSegment(this.extractColumnSegments((ParserRuleContext)onDuplicateKeyClauseNode.get())));
    }

    private Collection<ColumnSegment> extractColumnSegments(ParserRuleContext onDuplicateKeyClauseNode) {
        LinkedList<ColumnSegment> result = new LinkedList<ColumnSegment>();
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(onDuplicateKeyClauseNode, RuleName.COLUMN_NAME)) {
            Optional<ColumnSegment> columnSegment = this.columnExtractor.extract(each);
            if (!columnSegment.isPresent()) continue;
            result.add((ColumnSegment)columnSegment.get());
        }
        return result;
    }
}

