/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.select;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.common.table.TableNameExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.PredicateExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.common.TableSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.FromWhereSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.TableJoinSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.condition.OrConditionSegment;

public abstract class AbstractFromWhereExtractor
implements OptionalSQLSegmentExtractor {
    private final TableNameExtractor tableNameExtractor = new TableNameExtractor();
    private PredicateExtractor predicateSegmentExtractor = new PredicateExtractor();

    public Optional<FromWhereSegment> extract(ParserRuleContext ancestorNode) {
        return this.extract(ancestorNode, ancestorNode);
    }

    public Optional<FromWhereSegment> extract(ParserRuleContext ancestorNode, ParserRuleContext rootNode) {
        Map<ParserRuleContext, Integer> placeholderIndexes;
        FromWhereSegment result = this.createSegment();
        Optional<ParserRuleContext> whereNode = this.extractTable(result, ancestorNode, placeholderIndexes = this.getPlaceholderIndexes(result, rootNode));
        if (whereNode.isPresent()) {
            Collection<ParserRuleContext> questionNodes;
            result.setWhereStartIndex(((ParserRuleContext)whereNode.get()).getStart().getStartIndex());
            result.setWhereStopIndex(((ParserRuleContext)whereNode.get()).getStop().getStopIndex());
            if (!placeholderIndexes.isEmpty() && !(questionNodes = ExtractorUtils.getAllDescendantNodes((ParserRuleContext)whereNode.get(), RuleName.QUESTION)).isEmpty()) {
                int index = placeholderIndexes.get(questionNodes.iterator().next());
                result.setWhereParameterStartIndex(index);
                result.setWhereParameterEndIndex(index + questionNodes.size() - 1);
            }
            this.extractAndFillWhere(result, placeholderIndexes, (ParserRuleContext)whereNode.get());
        }
        return Optional.of((Object)result);
    }

    private Map<ParserRuleContext, Integer> getPlaceholderIndexes(FromWhereSegment fromWhereSegment, ParserRuleContext rootNode) {
        Collection<ParserRuleContext> placeholderNodes = ExtractorUtils.getAllDescendantNodes(rootNode, RuleName.QUESTION);
        HashMap<ParserRuleContext, Integer> result = new HashMap<ParserRuleContext, Integer>(placeholderNodes.size(), 1.0f);
        int index = 0;
        for (ParserRuleContext each : placeholderNodes) {
            result.put(each, index++);
        }
        fromWhereSegment.setParameterCount(placeholderNodes.size());
        return result;
    }

    protected FromWhereSegment createSegment() {
        return new FromWhereSegment();
    }

    protected abstract Optional<ParserRuleContext> extractTable(FromWhereSegment var1, ParserRuleContext var2, Map<ParserRuleContext, Integer> var3);

    protected void extractTableReference(FromWhereSegment fromWhereSegment, ParserRuleContext tableReferenceNode, Map<ParserRuleContext, Integer> placeholderIndexes) {
        for (int i = 0; i < tableReferenceNode.getChildCount(); ++i) {
            if (tableReferenceNode.getChild(i) instanceof TerminalNode) continue;
            ParserRuleContext childNode = (ParserRuleContext)tableReferenceNode.getChild(i);
            if (RuleName.TABLE_REFERENCES.getName().equals(childNode.getClass().getSimpleName())) {
                Collection<ParserRuleContext> subTableReferenceNodes = ExtractorUtils.getAllDescendantNodes(childNode, RuleName.TABLE_REFERENCE);
                for (ParserRuleContext each : subTableReferenceNodes) {
                    this.extractTableReference(fromWhereSegment, each, placeholderIndexes);
                }
                continue;
            }
            this.fillTable(fromWhereSegment, childNode, placeholderIndexes);
        }
    }

    protected void fillTable(FromWhereSegment fromWhereSegment, ParserRuleContext joinOrTableFactorNode, Map<ParserRuleContext, Integer> placeholderIndexes) {
        Optional<ParserRuleContext> joinConditionNode;
        if (!RuleName.JOIN_TABLE.getName().endsWith(joinOrTableFactorNode.getClass().getSimpleName())) {
            Optional<TableSegment> tableSegment = this.tableNameExtractor.extract(joinOrTableFactorNode);
            Preconditions.checkState((boolean)tableSegment.isPresent());
            this.fillTableResult(fromWhereSegment, (TableSegment)tableSegment.get());
        }
        if (!(joinConditionNode = ExtractorUtils.findFirstChildNode(joinOrTableFactorNode, RuleName.JOIN_CONDITION)).isPresent()) {
            return;
        }
        Optional<ParserRuleContext> tableFactorNode = ExtractorUtils.findFirstChildNode(joinOrTableFactorNode, RuleName.TABLE_FACTOR);
        Preconditions.checkState((boolean)tableFactorNode.isPresent());
        Optional<TableSegment> tableSegment = this.tableNameExtractor.extract((ParserRuleContext)tableFactorNode.get());
        Preconditions.checkState((boolean)tableSegment.isPresent());
        TableJoinSegment tableJoinResult = new TableJoinSegment((TableSegment)tableSegment.get());
        Optional<OrConditionSegment> conditionResult = this.buildCondition((ParserRuleContext)joinConditionNode.get(), placeholderIndexes);
        if (conditionResult.isPresent()) {
            tableJoinResult.getJoinConditions().getAndConditions().addAll(((OrConditionSegment)conditionResult.get()).getAndConditions());
            fromWhereSegment.getConditions().getAndConditions().addAll(((OrConditionSegment)conditionResult.get()).getAndConditions());
        }
        this.fillTableResult(fromWhereSegment, tableJoinResult);
    }

    protected void fillTableResult(FromWhereSegment fromWhereSegment, TableSegment tableSegment) {
        String alias = tableSegment.getName();
        if (tableSegment.getAlias().isPresent()) {
            alias = (String)tableSegment.getAlias().get();
        }
        fromWhereSegment.getTableAliases().put(alias, tableSegment.getName());
    }

    private void extractAndFillWhere(FromWhereSegment fromWhereSegment, Map<ParserRuleContext, Integer> placeholderIndexes, ParserRuleContext whereNode) {
        Optional<OrConditionSegment> conditions = this.buildCondition((ParserRuleContext)whereNode.getChild(1), placeholderIndexes);
        if (conditions.isPresent()) {
            fromWhereSegment.getConditions().getAndConditions().addAll(((OrConditionSegment)conditions.get()).getAndConditions());
        }
    }

    private Optional<OrConditionSegment> buildCondition(ParserRuleContext node, Map<ParserRuleContext, Integer> placeholderIndexes) {
        Optional<ParserRuleContext> exprNode = ExtractorUtils.findFirstChildNode(node, RuleName.EXPR);
        return exprNode.isPresent() ? this.predicateSegmentExtractor.extract(placeholderIndexes, (ParserRuleContext)exprNode.get()) : Optional.absent();
    }
}

