/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.select;

import com.google.common.base.Optional;
import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.limit.LimitSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.limit.LimitValueSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.limit.LiteralLimitValueSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.limit.PlaceholderLimitValueSegment;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.util.NumberUtil;

public final class LimitExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<LimitSegment> extract(ParserRuleContext ancestorNode) {
        Optional<ParserRuleContext> limitNode = ExtractorUtils.findFirstChildNode(ancestorNode, RuleName.LIMIT_CLAUSE);
        if (!limitNode.isPresent()) {
            return Optional.absent();
        }
        Map<ParserRuleContext, Integer> placeholderAndNodeIndexMap = this.getPlaceholderAndNodeIndexMap(ancestorNode);
        LimitValueSegment firstLimitValue = this.createLimitValueSegment(placeholderAndNodeIndexMap, (ParserRuleContext)((ParserRuleContext)limitNode.get()).getChild(1));
        if (((ParserRuleContext)limitNode.get()).getChildCount() >= 4) {
            LimitValueSegment rowCountLimitValue = this.createLimitValueSegment(placeholderAndNodeIndexMap, (ParserRuleContext)((ParserRuleContext)limitNode.get()).getChild(3));
            return Optional.of((Object)new LimitSegment(rowCountLimitValue, firstLimitValue));
        }
        return Optional.of((Object)new LimitSegment(firstLimitValue));
    }

    private Map<ParserRuleContext, Integer> getPlaceholderAndNodeIndexMap(ParserRuleContext ancestorNode) {
        HashMap<ParserRuleContext, Integer> result = new HashMap<ParserRuleContext, Integer>();
        int index = 0;
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.QUESTION)) {
            result.put(each, index++);
        }
        return result;
    }

    private LimitValueSegment createLimitValueSegment(Map<ParserRuleContext, Integer> placeholderAndNodeIndexMap, ParserRuleContext limitValueNode) {
        return Symbol.QUESTION.getLiterals().equals(limitValueNode.getText()) ? new PlaceholderLimitValueSegment(placeholderAndNodeIndexMap.get(limitValueNode.getChild(0)), ((ParserRuleContext)limitValueNode.getChild(0)).getStart().getStartIndex()) : new LiteralLimitValueSegment(NumberUtil.getExactlyNumber((String)limitValueNode.getText(), (int)10).intValue(), limitValueNode.getStart().getStartIndex());
    }
}

