/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.select;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedList;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.constant.OrderDirection;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.CollectionSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.order.item.ColumnNameOrderByItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.order.item.ExpressionOrderByItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.order.item.IndexOrderByItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.order.item.OrderByItemSegment;
import org.apache.shardingsphere.core.util.NumberUtil;

public final class OrderByItemExtractor
implements CollectionSQLSegmentExtractor {
    public Collection<OrderByItemSegment> extract(ParserRuleContext ancestorNode) {
        LinkedList<OrderByItemSegment> result = new LinkedList<OrderByItemSegment>();
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(ancestorNode, RuleName.ORDER_BY_ITEM)) {
            OrderDirection orderDirection = 2 == each.getChildCount() && OrderDirection.DESC.name().equalsIgnoreCase(each.getChild(1).getText()) ? OrderDirection.DESC : OrderDirection.ASC;
            Optional<ParserRuleContext> indexNode = ExtractorUtils.findFirstChildNode(each, RuleName.NUMBER);
            if (indexNode.isPresent()) {
                result.add(new IndexOrderByItemSegment(NumberUtil.getExactlyNumber((String)((ParserRuleContext)indexNode.get()).getText(), (int)10).intValue(), orderDirection, OrderDirection.ASC));
                continue;
            }
            Optional<ParserRuleContext> expressionNode = ExtractorUtils.findFirstChildNode(each, RuleName.EXPR);
            if (expressionNode.isPresent()) {
                result.add(new ExpressionOrderByItemSegment(((ParserRuleContext)expressionNode.get()).getText(), orderDirection, OrderDirection.ASC));
                continue;
            }
            Optional<ParserRuleContext> columnNameNode = ExtractorUtils.findFirstChildNode(each, RuleName.COLUMN_NAME);
            if (!columnNameNode.isPresent()) continue;
            result.add(new ColumnNameOrderByItemSegment(((ParserRuleContext)columnNameNode.get()).getText(), ((ParserRuleContext)each.getChild(0)).getStart().getStartIndex(), orderDirection, OrderDirection.ASC));
        }
        return result;
    }
}

