/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.select;

import com.google.common.base.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.select.item.SelectItemExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.SelectClauseSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.SelectItemSegment;

public final class SelectClauseExtractor
implements OptionalSQLSegmentExtractor {
    private final SelectItemExtractor selectItemExtractor = new SelectItemExtractor();

    public Optional<SelectClauseSegment> extract(ParserRuleContext ancestorNode) {
        ParserRuleContext selectClauseNode = ExtractorUtils.getFirstChildNode(ancestorNode, RuleName.SELECT_CLAUSE);
        ParserRuleContext selectExpressionsNode = ExtractorUtils.getFirstChildNode(selectClauseNode, RuleName.SELECT_EXPRS);
        SelectClauseSegment result = new SelectClauseSegment(selectExpressionsNode.getStart().getStartIndex(), selectExpressionsNode.getStop().getStopIndex(), this.hasDistinct(selectClauseNode));
        Optional<ParserRuleContext> unqualifiedShorthandNode = ExtractorUtils.findFirstChildNode(selectClauseNode, RuleName.UNQUALIFIED_SHORTHAND);
        if (unqualifiedShorthandNode.isPresent()) {
            this.setUnqualifiedShorthandSelectItemSegment((ParserRuleContext)unqualifiedShorthandNode.get(), result);
        }
        this.setSelectItemSegment(selectClauseNode, result);
        return Optional.of((Object)result);
    }

    private void setUnqualifiedShorthandSelectItemSegment(ParserRuleContext unqualifiedShorthandNode, SelectClauseSegment selectClauseSegment) {
        Optional<? extends SelectItemSegment> unqualifiedShorthandSelectItemSegment = this.selectItemExtractor.extract(unqualifiedShorthandNode);
        if (unqualifiedShorthandSelectItemSegment.isPresent()) {
            selectClauseSegment.getSelectItems().add((SelectItemSegment)unqualifiedShorthandSelectItemSegment.get());
        }
    }

    private void setSelectItemSegment(ParserRuleContext selectClauseNode, SelectClauseSegment selectClauseSegment) {
        for (ParserRuleContext each : ExtractorUtils.getAllDescendantNodes(selectClauseNode, RuleName.SELECT_EXPR)) {
            Optional<? extends SelectItemSegment> selectItemSegment = this.selectItemExtractor.extract(each);
            if (!selectItemSegment.isPresent()) continue;
            selectClauseSegment.getSelectItems().add((SelectItemSegment)selectItemSegment.get());
        }
    }

    private boolean hasDistinct(ParserRuleContext selectClauseNode) {
        return ExtractorUtils.findFirstChildNode(ExtractorUtils.getFirstChildNode(selectClauseNode, RuleName.SELECT_SPECIFICATION), RuleName.DISTINCT).isPresent();
    }
}

