/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.select;

import com.google.common.base.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.select.FromWhereExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.select.GroupByExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.select.OrderByExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.select.SelectClauseExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.FromWhereSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.SelectClauseSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.SubquerySegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.order.OrderBySegment;

public final class SubqueryExtractor
implements OptionalSQLSegmentExtractor {
    private final FromWhereExtractor fromWhereExtractor = new FromWhereExtractor();
    private final GroupByExtractor groupByExtractor = new GroupByExtractor();
    private final OrderByExtractor orderByExtractor = new OrderByExtractor();

    public Optional<SubquerySegment> extract(ParserRuleContext subqueryNode) {
        Optional<ParserRuleContext> aliasNode;
        Optional<OrderBySegment> orderBySegment;
        Optional<GroupBySegment> groupBySegment;
        Optional<FromWhereSegment> fromWhereSegment;
        if (!RuleName.SUBQUERY.getName().endsWith(subqueryNode.getClass().getSimpleName())) {
            return Optional.absent();
        }
        boolean subqueryInFrom = false;
        for (ParserRuleContext parentNode = subqueryNode.getParent(); null != parentNode; parentNode = parentNode.getParent()) {
            if (!RuleName.FROM_CLAUSE.getName().equals(parentNode.getClass().getSimpleName())) continue;
            subqueryInFrom = true;
            break;
        }
        SubquerySegment result = new SubquerySegment(subqueryNode.getStart().getStartIndex(), subqueryNode.getStop().getStopIndex(), subqueryInFrom);
        Optional<SelectClauseSegment> selectClauseSegment = new SelectClauseExtractor().extract(subqueryNode);
        if (selectClauseSegment.isPresent()) {
            result.setSelectClauseSegment((SelectClauseSegment)selectClauseSegment.get());
        }
        if ((fromWhereSegment = this.fromWhereExtractor.extract(subqueryNode)).isPresent()) {
            result.setFromWhereSegment((FromWhereSegment)fromWhereSegment.get());
        }
        if ((groupBySegment = this.groupByExtractor.extract(subqueryNode)).isPresent()) {
            result.setGroupBySegment((GroupBySegment)groupBySegment.get());
        }
        if ((orderBySegment = this.orderByExtractor.extract(subqueryNode)).isPresent()) {
            result.setOrderBySegment((OrderBySegment)orderBySegment.get());
        }
        if ((aliasNode = ExtractorUtils.findFirstChildNode(subqueryNode.getParent(), RuleName.ALIAS)).isPresent()) {
            result.setAlias(((ParserRuleContext)aliasNode.get()).getText());
        }
        return Optional.of((Object)result);
    }
}

