/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.extractor.impl.dml.select.item;

import com.google.common.base.Optional;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.shardingsphere.core.constant.AggregationType;
import org.apache.shardingsphere.core.parse.antlr.extractor.api.OptionalSQLSegmentExtractor;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.ExtractorUtils;
import org.apache.shardingsphere.core.parse.antlr.extractor.util.RuleName;
import org.apache.shardingsphere.core.parse.antlr.sql.AliasAvailable;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.AggregationDistinctSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.AggregationSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.ExpressionSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.SelectItemSegment;

public final class FunctionSelectItemSegmentExtractor
implements OptionalSQLSegmentExtractor {
    public Optional<SelectItemSegment> extract(ParserRuleContext expressionNode) {
        Optional<ParserRuleContext> functionNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.FUNCTION_CALL);
        if (!functionNode.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)this.extractFunctionSelectItemSegment(expressionNode, (ParserRuleContext)functionNode.get()));
    }

    private SelectItemSegment extractFunctionSelectItemSegment(ParserRuleContext expressionNode, ParserRuleContext functionNode) {
        String functionName = functionNode.getChild(0).getText();
        Optional<AggregationType> aggregationType = this.findAggregationType(functionName);
        AliasAvailable result = aggregationType.isPresent() ? this.extractAggregationSelectItemSegment((AggregationType)aggregationType.get(), functionNode) : new ExpressionSelectItemSegment(functionNode.getText(), functionNode.getStart().getStartIndex(), functionNode.getStop().getStopIndex());
        Optional<ParserRuleContext> aliasNode = ExtractorUtils.findFirstChildNode(expressionNode, RuleName.ALIAS);
        if (aliasNode.isPresent()) {
            result.setAlias(((ParserRuleContext)aliasNode.get()).getText());
        }
        return (SelectItemSegment)((Object)result);
    }

    private Optional<AggregationType> findAggregationType(String functionName) {
        try {
            return Optional.of((Object)AggregationType.valueOf((String)functionName.toUpperCase()));
        }
        catch (IllegalArgumentException ignore) {
            return Optional.absent();
        }
    }

    private AggregationSelectItemSegment extractAggregationSelectItemSegment(AggregationType type, ParserRuleContext functionNode) {
        int innerExpressionStartIndex = ((TerminalNode)functionNode.getChild(1)).getSymbol().getStartIndex();
        return ExtractorUtils.findFirstChildNode(functionNode, RuleName.DISTINCT).isPresent() ? new AggregationDistinctSelectItemSegment(type, innerExpressionStartIndex, functionNode.getStart().getStartIndex(), functionNode.getStop().getStopIndex(), this.getDistinctExpression(functionNode)) : new AggregationSelectItemSegment(type, innerExpressionStartIndex, functionNode.getStart().getStartIndex(), functionNode.getStop().getStopIndex());
    }

    private String getDistinctExpression(ParserRuleContext functionNode) {
        StringBuilder result = new StringBuilder();
        for (int i = 3; i < functionNode.getChildCount() - 1; ++i) {
            result.append(functionNode.getChild(i).getText());
        }
        return result.toString();
    }
}

