/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler;

import com.google.common.base.Optional;
import java.util.Collection;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.filler.api.EncryptRuleAwareFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.api.ShardingRuleAwareFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.api.ShardingTableMetaDataAwareFiller;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.ParsingRuleRegistry;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.statement.SQLStatementRule;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.SQLSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.rule.BaseRule;
import org.apache.shardingsphere.core.rule.EncryptRule;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class SQLStatementFillerEngine {
    private final ParsingRuleRegistry parsingRuleRegistry;
    private final DatabaseType databaseType;
    private final String sql;
    private final BaseRule rule;
    private final ShardingTableMetaData shardingTableMetaData;

    public SQLStatementFillerEngine(ParsingRuleRegistry parsingRuleRegistry, DatabaseType databaseType, String sql, BaseRule rule, ShardingTableMetaData shardingTableMetaData) {
        this.parsingRuleRegistry = parsingRuleRegistry;
        this.databaseType = databaseType;
        this.sql = sql;
        this.rule = rule;
        this.shardingTableMetaData = shardingTableMetaData;
    }

    public SQLStatement fill(Collection<SQLSegment> sqlSegments, SQLStatementRule rule) {
        SQLStatement result = rule.getSqlStatementClass().newInstance();
        result.setLogicSQL(this.sql);
        for (SQLSegment each : sqlSegments) {
            Optional<SQLSegmentFiller> filler = this.parsingRuleRegistry.findSQLSegmentFiller(this.databaseType, each.getClass());
            if (!filler.isPresent()) continue;
            this.doFill(each, result, (SQLSegmentFiller)filler.get());
        }
        return result;
    }

    private void doFill(SQLSegment sqlSegment, SQLStatement sqlStatement, SQLSegmentFiller filler) {
        if (filler instanceof ShardingRuleAwareFiller) {
            ((ShardingRuleAwareFiller)((Object)filler)).setShardingRule((ShardingRule)this.rule);
        }
        if (filler instanceof EncryptRuleAwareFiller) {
            ((EncryptRuleAwareFiller)((Object)filler)).setEncryptRule((EncryptRule)this.rule);
        }
        if (filler instanceof ShardingTableMetaDataAwareFiller) {
            ((ShardingTableMetaDataAwareFiller)((Object)filler)).setShardingTableMetaData(this.shardingTableMetaData);
        }
        filler.fill(sqlSegment, sqlStatement);
    }
}

