/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.common.ddl;

import com.google.common.base.Optional;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.api.ShardingTableMetaDataAwareFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.ddl.constraint.ConstraintDefinitionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.AlterTableStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.CreateTableStatement;

public final class ConstraintDefinitionFiller
implements SQLSegmentFiller<ConstraintDefinitionSegment>,
ShardingTableMetaDataAwareFiller {
    private ShardingTableMetaData shardingTableMetaData;

    @Override
    public void fill(ConstraintDefinitionSegment sqlSegment, SQLStatement sqlStatement) {
        if (sqlStatement instanceof CreateTableStatement) {
            this.fill(sqlSegment, (CreateTableStatement)sqlStatement);
        } else if (sqlStatement instanceof AlterTableStatement) {
            this.fill(sqlSegment, (AlterTableStatement)sqlStatement, this.shardingTableMetaData);
        }
    }

    private void fill(ConstraintDefinitionSegment sqlSegment, CreateTableStatement createTableStatement) {
        for (ColumnDefinitionSegment each : createTableStatement.getColumnDefinitions()) {
            if (!sqlSegment.getPrimaryKeyColumnNames().contains(each.getColumnName())) continue;
            each.setPrimaryKey(true);
        }
    }

    private void fill(ConstraintDefinitionSegment sqlSegment, AlterTableStatement alterTableStatement, ShardingTableMetaData shardingTableMetaData) {
        for (String each : sqlSegment.getPrimaryKeyColumnNames()) {
            Optional<ColumnDefinitionSegment> modifiedColumn = alterTableStatement.findColumnDefinition(each, shardingTableMetaData);
            if (!modifiedColumn.isPresent()) continue;
            ((ColumnDefinitionSegment)modifiedColumn.get()).setPrimaryKey(true);
            alterTableStatement.getModifiedColumnDefinitions().put(each, (ColumnDefinitionSegment)modifiedColumn.get());
        }
    }

    @Override
    public void setShardingTableMetaData(ShardingTableMetaData shardingTableMetaData) {
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

