/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.common.ddl.alter;

import com.google.common.base.Optional;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.api.ShardingTableMetaDataAwareFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.ddl.column.position.ColumnPositionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.AlterTableStatement;

public final class ModifyColumnDefinitionFiller
implements SQLSegmentFiller<ModifyColumnDefinitionSegment>,
ShardingTableMetaDataAwareFiller {
    private ShardingTableMetaData shardingTableMetaData;

    @Override
    public void fill(ModifyColumnDefinitionSegment sqlSegment, SQLStatement sqlStatement) {
        AlterTableStatement alterTableStatement = (AlterTableStatement)sqlStatement;
        Optional<String> oldColumnName = sqlSegment.getOldColumnName();
        if (oldColumnName.isPresent()) {
            Optional<ColumnDefinitionSegment> oldColumnDefinition = alterTableStatement.findColumnDefinition((String)oldColumnName.get(), this.shardingTableMetaData);
            if (!oldColumnDefinition.isPresent()) {
                return;
            }
            ((ColumnDefinitionSegment)oldColumnDefinition.get()).setColumnName(sqlSegment.getColumnDefinition().getColumnName());
            if (null != sqlSegment.getColumnDefinition().getDataType()) {
                ((ColumnDefinitionSegment)oldColumnDefinition.get()).setDataType(sqlSegment.getColumnDefinition().getDataType());
            }
            alterTableStatement.getModifiedColumnDefinitions().put((String)oldColumnName.get(), (ColumnDefinitionSegment)oldColumnDefinition.get());
        } else {
            alterTableStatement.getModifiedColumnDefinitions().put(sqlSegment.getColumnDefinition().getColumnName(), sqlSegment.getColumnDefinition());
        }
        if (sqlSegment.getColumnPosition().isPresent()) {
            alterTableStatement.getChangedPositionColumns().add((ColumnPositionSegment)sqlSegment.getColumnPosition().get());
        }
    }

    @Override
    public void setShardingTableMetaData(ShardingTableMetaData shardingTableMetaData) {
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

