/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.common.ddl.alter;

import com.google.common.base.Optional;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.api.ShardingTableMetaDataAwareFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.ddl.column.alter.RenameColumnSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.AlterTableStatement;

public final class RenameColumnDefinitionFiller
implements SQLSegmentFiller<RenameColumnSegment>,
ShardingTableMetaDataAwareFiller {
    private ShardingTableMetaData shardingTableMetaData;

    @Override
    public void fill(RenameColumnSegment sqlSegment, SQLStatement sqlStatement) {
        AlterTableStatement alterTableStatement = (AlterTableStatement)sqlStatement;
        Optional<ColumnDefinitionSegment> oldColumnDefinition = alterTableStatement.findColumnDefinition(sqlSegment.getOldColumnName(), this.shardingTableMetaData);
        if (!oldColumnDefinition.isPresent()) {
            return;
        }
        ((ColumnDefinitionSegment)oldColumnDefinition.get()).setColumnName(sqlSegment.getColumnName());
        alterTableStatement.getModifiedColumnDefinitions().put(sqlSegment.getOldColumnName(), (ColumnDefinitionSegment)oldColumnDefinition.get());
    }

    @Override
    public void setShardingTableMetaData(ShardingTableMetaData shardingTableMetaData) {
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

