/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.common.dml;

import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.api.ShardingTableMetaDataAwareFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.InsertColumnsSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.InsertValuesToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.TableToken;

public final class InsertColumnsFiller
implements SQLSegmentFiller<InsertColumnsSegment>,
ShardingTableMetaDataAwareFiller {
    private ShardingTableMetaData shardingTableMetaData;

    @Override
    public void fill(InsertColumnsSegment sqlSegment, SQLStatement sqlStatement) {
        if (sqlStatement instanceof InsertStatement) {
            InsertStatement insertStatement = (InsertStatement)sqlStatement;
            if (sqlSegment.getColumns().isEmpty()) {
                this.fillFromMetaData(insertStatement);
            } else {
                this.fillFromSQL(sqlSegment, insertStatement);
            }
            insertStatement.getSQLTokens().add(new InsertValuesToken(sqlSegment.getStartIndex()));
        }
    }

    private void fillFromMetaData(InsertStatement insertStatement) {
        String tableName = insertStatement.getTables().getSingleTableName();
        for (String each : this.shardingTableMetaData.getAllColumnNames(tableName)) {
            insertStatement.getColumnNames().add(each);
        }
    }

    private void fillFromSQL(InsertColumnsSegment sqlSegment, InsertStatement insertStatement) {
        String tableName = insertStatement.getTables().getSingleTableName();
        for (ColumnSegment each : sqlSegment.getColumns()) {
            insertStatement.getColumnNames().add(each.getName());
            if (!each.getOwner().isPresent() || !tableName.equals(each.getOwner().get())) continue;
            insertStatement.getSQLTokens().add(new TableToken(each.getStartIndex(), tableName, QuoteCharacter.getQuoteCharacter(tableName), 0));
        }
    }

    @Override
    public void setShardingTableMetaData(ShardingTableMetaData shardingTableMetaData) {
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

