/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.common.dql;

import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.limit.LimitSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.limit.LimitValueSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.limit.LiteralLimitValueSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.limit.PlaceholderLimitValueSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.OffsetToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.RowCountToken;
import org.apache.shardingsphere.core.parse.old.parser.context.limit.Limit;
import org.apache.shardingsphere.core.parse.old.parser.context.limit.LimitValue;

public final class LimitFiller
implements SQLSegmentFiller<LimitSegment> {
    @Override
    public void fill(LimitSegment sqlSegment, SQLStatement sqlStatement) {
        SelectStatement selectStatement = (SelectStatement)sqlStatement;
        selectStatement.setLimit(new Limit());
        if (sqlSegment.getOffset().isPresent()) {
            this.setOffset((LimitValueSegment)sqlSegment.getOffset().get(), selectStatement);
        }
        this.setRowCount(sqlSegment.getRowCount(), selectStatement);
    }

    private void setOffset(LimitValueSegment offsetSegment, SelectStatement selectStatement) {
        if (offsetSegment instanceof LiteralLimitValueSegment) {
            int value = ((LiteralLimitValueSegment)offsetSegment).getValue();
            selectStatement.getLimit().setOffset(new LimitValue(value, -1, false));
            selectStatement.getSQLTokens().add(new OffsetToken(offsetSegment.getStartIndex(), value));
        } else {
            selectStatement.getLimit().setOffset(new LimitValue(-1, ((PlaceholderLimitValueSegment)offsetSegment).getParameterIndex(), false));
        }
    }

    private void setRowCount(LimitValueSegment rowCountSegment, SelectStatement selectStatement) {
        if (rowCountSegment instanceof LiteralLimitValueSegment) {
            int value = ((LiteralLimitValueSegment)rowCountSegment).getValue();
            selectStatement.getLimit().setRowCount(new LimitValue(value, -1, false));
            selectStatement.getSQLTokens().add(new RowCountToken(rowCountSegment.getStartIndex(), value));
        } else {
            selectStatement.getLimit().setRowCount(new LimitValue(-1, ((PlaceholderLimitValueSegment)rowCountSegment).getParameterIndex(), false));
        }
    }
}

