/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.common.dql;

import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.api.ShardingTableMetaDataAwareFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.common.dql.SelectItemFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.SelectClauseSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.AggregationDistinctSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.AggregationSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.ColumnSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.ExpressionSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.SelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.StarSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.old.parser.constant.DerivedAlias;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.DistinctSelectItem;

public final class SelectClauseFiller
implements SQLSegmentFiller<SelectClauseSegment>,
ShardingTableMetaDataAwareFiller {
    private ShardingTableMetaData shardingTableMetaData;
    private SelectItemFiller selectItemFiller;

    @Override
    public void fill(SelectClauseSegment sqlSegment, SQLStatement sqlStatement) {
        this.selectItemFiller = new SelectItemFiller(this.shardingTableMetaData);
        SelectStatement selectStatement = (SelectStatement)sqlStatement;
        selectStatement.setFirstSelectItemStartIndex(sqlSegment.getFirstSelectItemStartIndex());
        selectStatement.setSelectListStopIndex(sqlSegment.getSelectItemsStopIndex());
        if (sqlSegment.isHasDistinct()) {
            this.fillDistinct(sqlSegment, selectStatement);
            return;
        }
        int offset = 0;
        for (SelectItemSegment each : sqlSegment.getSelectItems()) {
            offset = this.setDistinctFunctionAlias(each, offset);
            this.selectItemFiller.fill(each, sqlStatement);
        }
    }

    private void fillDistinct(SelectClauseSegment selectClauseSegment, SelectStatement selectStatement) {
        Iterator<SelectItemSegment> selectItemSegmentIterator = selectClauseSegment.getSelectItems().iterator();
        SelectItemSegment firstSelectItemSegment = selectItemSegmentIterator.next();
        LinkedHashSet<String> distinctColumnNames = new LinkedHashSet<String>();
        DistinctSelectItem distinctSelectItem = null;
        int offset = 0;
        if (firstSelectItemSegment instanceof StarSelectItemSegment) {
            this.selectItemFiller.fill(firstSelectItemSegment, (SQLStatement)selectStatement);
            selectStatement.getItems().add(new DistinctSelectItem(distinctColumnNames, (Optional<String>)Optional.absent()));
        } else if (firstSelectItemSegment instanceof ColumnSelectItemSegment) {
            ColumnSelectItemSegment columnSelectItemSegment = (ColumnSelectItemSegment)firstSelectItemSegment;
            distinctSelectItem = new DistinctSelectItem(distinctColumnNames, columnSelectItemSegment.getAlias());
            selectStatement.getItems().add(distinctSelectItem);
            distinctColumnNames.add(columnSelectItemSegment.getName());
        } else if (firstSelectItemSegment instanceof ExpressionSelectItemSegment) {
            distinctSelectItem = this.createDistinctExpressionItem(selectStatement, distinctColumnNames, (ExpressionSelectItemSegment)firstSelectItemSegment);
        } else {
            offset = this.setDistinctFunctionAlias(firstSelectItemSegment, offset);
            this.selectItemFiller.fill(firstSelectItemSegment, (SQLStatement)selectStatement);
        }
        while (selectItemSegmentIterator.hasNext()) {
            SelectItemSegment nextSelectItemSegment = selectItemSegmentIterator.next();
            this.selectItemFiller.fill(nextSelectItemSegment, (SQLStatement)selectStatement);
            if (!(nextSelectItemSegment instanceof ColumnSelectItemSegment)) continue;
            offset = this.setDistinctFunctionAlias(nextSelectItemSegment, offset);
            distinctColumnNames.add(((ColumnSelectItemSegment)nextSelectItemSegment).getName());
        }
        if (null != distinctSelectItem) {
            distinctSelectItem.getDistinctColumnNames().addAll(distinctColumnNames);
        }
    }

    private int setDistinctFunctionAlias(SelectItemSegment selectItemSegment, int offset) {
        if (selectItemSegment instanceof AggregationSelectItemSegment) {
            AggregationSelectItemSegment aggregationSelectItemSegment = (AggregationSelectItemSegment)selectItemSegment;
            Optional<String> alias = aggregationSelectItemSegment.getAlias();
            if (aggregationSelectItemSegment instanceof AggregationDistinctSelectItemSegment && !alias.isPresent()) {
                ((AggregationSelectItemSegment)selectItemSegment).setAlias(DerivedAlias.AGGREGATION_DISTINCT_DERIVED.getDerivedAlias(offset));
                return offset + 1;
            }
        }
        return offset;
    }

    private DistinctSelectItem createDistinctExpressionItem(SelectStatement selectStatement, Set<String> distinctColumnNames, ExpressionSelectItemSegment expressionSelectItemSegment) {
        DistinctSelectItem distinctSelectItem = new DistinctSelectItem(distinctColumnNames, expressionSelectItemSegment.getAlias());
        String commonExpression = selectStatement.getLogicSQL().substring(expressionSelectItemSegment.getStartIndex(), expressionSelectItemSegment.getStopIndex() + 1);
        int leftParenPosition = commonExpression.indexOf("(");
        if (0 <= leftParenPosition) {
            int rightParenPosition = commonExpression.lastIndexOf(")");
            if (0 > rightParenPosition) {
                rightParenPosition = commonExpression.length();
            }
            distinctColumnNames.add(commonExpression.substring(leftParenPosition + 1, rightParenPosition));
        }
        selectStatement.getItems().add(distinctSelectItem);
        return distinctSelectItem;
    }

    @Override
    public void setShardingTableMetaData(ShardingTableMetaData shardingTableMetaData) {
        this.shardingTableMetaData = shardingTableMetaData;
    }

    public void setSelectItemFiller(SelectItemFiller selectItemFiller) {
        this.selectItemFiller = selectItemFiller;
    }
}

