/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.common.dql;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.common.dql.SubqueryFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.SQLSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.SubquerySegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.AggregationDistinctSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.AggregationSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.ColumnSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.ExpressionSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.StarSelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.AggregationDistinctToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.TableToken;
import org.apache.shardingsphere.core.parse.old.parser.constant.DerivedAlias;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.AggregationDistinctSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.AggregationSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.CommonSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.StarSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.table.Table;

public final class SelectItemFiller
implements SQLSegmentFiller {
    private final ShardingTableMetaData shardingTableMetaData;

    public void fill(SQLSegment sqlSegment, SQLStatement sqlStatement) {
        if (!(sqlStatement instanceof SelectStatement)) {
            return;
        }
        SelectStatement selectStatement = (SelectStatement)sqlStatement;
        if (sqlSegment instanceof StarSelectItemSegment) {
            this.fillStarSelectItemSegment((StarSelectItemSegment)sqlSegment, selectStatement);
            return;
        }
        if (sqlSegment instanceof ColumnSelectItemSegment) {
            this.fillColumnSelectItemSegment((ColumnSelectItemSegment)sqlSegment, selectStatement);
            return;
        }
        if (sqlSegment instanceof ExpressionSelectItemSegment) {
            this.fillExpressionSelectItemSegment((ExpressionSelectItemSegment)sqlSegment, selectStatement);
            return;
        }
        if (sqlSegment instanceof AggregationSelectItemSegment) {
            this.fillAggregationSelectItemSegment((AggregationSelectItemSegment)sqlSegment, selectStatement);
            return;
        }
        if (sqlSegment instanceof SubquerySegment) {
            this.fillSubquerySegment((SubquerySegment)sqlSegment, sqlStatement);
        }
    }

    private void fillStarSelectItemSegment(StarSelectItemSegment selectItemSegment, SelectStatement selectStatement) {
        Optional<Table> table;
        selectStatement.setContainStar(true);
        Optional<String> owner = selectItemSegment.getOwner();
        selectStatement.getItems().add(new StarSelectItem((String)owner.orNull()));
        if (owner.isPresent() && (table = selectStatement.getTables().find((String)owner.get())).isPresent() && !((Table)table.get()).getAlias().isPresent() && this.shardingTableMetaData.containsTable(((Table)table.get()).getName())) {
            selectStatement.addSQLToken(new TableToken(selectItemSegment.getStartIndex(), (String)owner.get(), QuoteCharacter.getQuoteCharacter((String)owner.get()), 0));
        }
    }

    private void fillColumnSelectItemSegment(ColumnSelectItemSegment selectItemSegment, SelectStatement selectStatement) {
        Optional<Table> table;
        Optional<String> owner = selectItemSegment.getOwner();
        if (owner.isPresent() && (table = selectStatement.getTables().find((String)owner.get())).isPresent() && !((Table)table.get()).getAlias().isPresent() && this.shardingTableMetaData.containsTable(((Table)table.get()).getName())) {
            selectStatement.addSQLToken(new TableToken(selectItemSegment.getStartIndex(), (String)owner.get(), QuoteCharacter.getQuoteCharacter((String)owner.get()), 0));
        }
        selectStatement.getItems().add(new CommonSelectItem(selectItemSegment.getQualifiedName(), selectItemSegment.getAlias()));
    }

    private void fillExpressionSelectItemSegment(ExpressionSelectItemSegment selectItemSegment, SelectStatement selectStatement) {
        selectStatement.getItems().add(new CommonSelectItem(selectItemSegment.getExpression(), selectItemSegment.getAlias()));
    }

    private void fillAggregationSelectItemSegment(AggregationSelectItemSegment selectItemSegment, SelectStatement selectStatement) {
        if (selectItemSegment instanceof AggregationDistinctSelectItemSegment) {
            this.fillAggregationDistinctSelectItemSegment((AggregationDistinctSelectItemSegment)selectItemSegment, selectStatement);
        } else {
            selectStatement.getItems().add(new AggregationSelectItem(selectItemSegment.getType(), selectStatement.getLogicSQL().substring(selectItemSegment.getInnerExpressionStartIndex(), selectItemSegment.getStopIndex() + 1), selectItemSegment.getAlias()));
        }
    }

    private void fillAggregationDistinctSelectItemSegment(AggregationDistinctSelectItemSegment selectItemSegment, SelectStatement selectStatement) {
        selectStatement.getItems().add(new AggregationDistinctSelectItem(selectItemSegment.getType(), selectStatement.getLogicSQL().substring(selectItemSegment.getInnerExpressionStartIndex(), selectItemSegment.getStopIndex() + 1), selectItemSegment.getAlias(), selectItemSegment.getDistinctExpression()));
        Optional derivedAlias = Optional.absent();
        if (DerivedAlias.isDerivedAlias((String)selectItemSegment.getAlias().get())) {
            derivedAlias = Optional.of((Object)selectItemSegment.getAlias().get());
        }
        selectStatement.getSQLTokens().add(new AggregationDistinctToken(selectItemSegment.getStartIndex(), selectItemSegment.getStopIndex(), selectItemSegment.getDistinctExpression(), (Optional<String>)derivedAlias));
    }

    private void fillSubquerySegment(SubquerySegment subquerySegment, SQLStatement sqlStatement) {
        new SubqueryFiller().fill(subquerySegment, sqlStatement);
    }

    @ConstructorProperties(value={"shardingTableMetaData"})
    public SelectItemFiller(ShardingTableMetaData shardingTableMetaData) {
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

