/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.common.dql;

import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.common.dql.GroupByFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.common.dql.OrderByFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.common.dql.SelectClauseFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.SelectClauseSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.SubquerySegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;

public final class SubqueryFiller
implements SQLSegmentFiller<SubquerySegment> {
    @Override
    public void fill(SubquerySegment sqlSegment, SQLStatement sqlStatement) {
        SelectStatement selectStatement = (SelectStatement)sqlStatement;
        SelectStatement subqueryStatement = new SelectStatement();
        subqueryStatement.setParentStatement(selectStatement);
        selectStatement.getSubqueryStatements().add(subqueryStatement);
        if (sqlSegment.getSelectClauseSegment().isPresent()) {
            new SelectClauseFiller().fill((SelectClauseSegment)sqlSegment.getSelectClauseSegment().get(), (SQLStatement)subqueryStatement);
        }
        if (sqlSegment.getFromWhereSegment().isPresent()) {
            // empty if block
        }
        if (!sqlSegment.isSubqueryInFrom()) {
            return;
        }
        if (sqlSegment.getGroupBySegment().isPresent()) {
            new GroupByFiller().fill((GroupBySegment)sqlSegment.getGroupBySegment().get(), (SQLStatement)subqueryStatement);
        }
        if (sqlSegment.getOrderBySegment().isPresent()) {
            new OrderByFiller().fill((OrderBySegment)sqlSegment.getOrderBySegment().get(), (SQLStatement)subqueryStatement);
        }
    }
}

