/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.encrypt.dml;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.metadata.table.TableMetaData;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.condition.AndConditionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.condition.ConditionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.condition.OrConditionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.EncryptColumnToken;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.AndCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Column;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.OrCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.table.Table;
import org.apache.shardingsphere.core.parse.old.parser.context.table.Tables;
import org.apache.shardingsphere.core.rule.EncryptRule;

public class EncryptOrConditionFiller
implements SQLSegmentFiller<OrConditionSegment> {
    private final EncryptRule encryptRule;
    private final ShardingTableMetaData shardingTableMetaData;

    @Override
    public void fill(OrConditionSegment sqlSegment, SQLStatement sqlStatement) {
        HashMap<String, String> columnNameToTable = new HashMap<String, String>();
        HashMap<String, Integer> columnNameCount = new HashMap<String, Integer>();
        this.fillColumnTableMap(sqlStatement, columnNameToTable, columnNameCount);
        this.filterCondition(sqlStatement, sqlSegment);
    }

    private void fillColumnTableMap(SQLStatement sqlStatement, Map<String, String> columnNameToTable, Map<String, Integer> columnNameCount) {
        if (null == this.shardingTableMetaData) {
            return;
        }
        for (String each : sqlStatement.getTables().getTableNames()) {
            Collection tableColumns = this.shardingTableMetaData.getAllColumnNames(each);
            for (String columnName : tableColumns) {
                columnNameToTable.put(columnName, each);
                Integer count = columnNameCount.get(columnName);
                if (null == count) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                columnNameCount.put(columnName, count);
            }
        }
    }

    private OrCondition filterCondition(SQLStatement sqlStatement, OrConditionSegment orCondition) {
        OrCondition result = new OrCondition();
        HashSet<Integer> filledConditionStopIndexes = new HashSet<Integer>();
        for (AndConditionSegment each : orCondition.getAndConditions()) {
            for (ConditionSegment condition : each.getConditions()) {
                if (null == condition.getColumn() || filledConditionStopIndexes.contains(condition.getStopIndex())) continue;
                filledConditionStopIndexes.add(condition.getStopIndex());
                Column column = new Column(condition.getColumn().getName(), this.getTableName(sqlStatement, condition));
                this.fillEncryptCondition(column, condition, sqlStatement);
            }
        }
        return result;
    }

    private void fillEncryptCondition(Column column, ConditionSegment condition, SQLStatement sqlStatement) {
        AndCondition andCondition;
        if (!this.encryptRule.getEncryptorEngine().getShardingEncryptor(column.getTableName(), column.getName()).isPresent()) {
            return;
        }
        if (0 == sqlStatement.getEncryptConditions().getOrCondition().getAndConditions().size()) {
            andCondition = new AndCondition();
            sqlStatement.getEncryptConditions().getOrCondition().getAndConditions().add(andCondition);
        } else {
            andCondition = sqlStatement.getEncryptConditions().getOrCondition().getAndConditions().get(0);
        }
        andCondition.getConditions().add(condition.getExpression().buildCondition(column, sqlStatement.getLogicSQL()));
        sqlStatement.getSQLTokens().add(new EncryptColumnToken(condition.getColumn().getStartIndex(), condition.getStopIndex(), column, true));
    }

    private String getTableName(SQLStatement sqlStatement, ConditionSegment conditionSegment) {
        if (!(sqlStatement instanceof SelectStatement)) {
            return this.getTableName(sqlStatement.getTables(), conditionSegment);
        }
        SelectStatement currentSelectStatement = (SelectStatement)sqlStatement;
        while (null != currentSelectStatement.getParentStatement()) {
            String tableName = this.getTableName((currentSelectStatement = currentSelectStatement.getParentStatement()).getTables(), conditionSegment);
            if ("".equals(tableName)) continue;
            return tableName;
        }
        return this.getTableName(currentSelectStatement.getTables(), conditionSegment);
    }

    private String getTableName(Tables tables, ConditionSegment conditionSegment) {
        if (conditionSegment.getColumn().getOwner().isPresent()) {
            Optional<Table> table = tables.find((String)conditionSegment.getColumn().getOwner().get());
            return table.isPresent() ? ((Table)table.get()).getName() : "";
        }
        return this.getTableNameFromMetaData(tables, conditionSegment.getColumn().getName());
    }

    private String getTableNameFromMetaData(Tables tables, String columnName) {
        for (String each : tables.getTableNames()) {
            TableMetaData tableMetaData = this.shardingTableMetaData.get(each);
            if (null == tableMetaData || !tableMetaData.getColumns().containsKey(columnName)) continue;
            return each;
        }
        return "";
    }

    @ConstructorProperties(value={"encryptRule", "shardingTableMetaData"})
    public EncryptOrConditionFiller(EncryptRule encryptRule, ShardingTableMetaData shardingTableMetaData) {
        this.encryptRule = encryptRule;
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

