/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.encrypt.dml;

import java.util.LinkedList;
import org.apache.shardingsphere.core.parse.antlr.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.assignment.SetAssignmentsSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.InsertSetToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.TableToken;
import org.apache.shardingsphere.core.parse.old.parser.context.insertvalue.InsertValue;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;

public final class EncryptSetAssignmentsFiller
implements SQLSegmentFiller<SetAssignmentsSegment> {
    @Override
    public void fill(SetAssignmentsSegment sqlSegment, SQLStatement sqlStatement) {
        InsertStatement insertStatement = (InsertStatement)sqlStatement;
        String tableName = insertStatement.getTables().getSingleTableName();
        for (AssignmentSegment each : sqlSegment.getAssignments()) {
            this.fillColumn(each.getColumn(), insertStatement, tableName);
        }
        InsertValue insertValue = this.getInsertValue(sqlSegment, sqlStatement.getLogicSQL());
        insertStatement.getValues().add(insertValue);
        insertStatement.setParametersIndex(insertValue.getParametersCount());
        insertStatement.getSQLTokens().add(new InsertSetToken(sqlSegment.getStartIndex()));
    }

    private void fillColumn(ColumnSegment sqlSegment, InsertStatement insertStatement, String tableName) {
        insertStatement.getColumnNames().add(sqlSegment.getName());
        if (sqlSegment.getOwner().isPresent() && tableName.equals(sqlSegment.getOwner().get())) {
            insertStatement.getSQLTokens().add(new TableToken(sqlSegment.getStartIndex(), tableName, QuoteCharacter.getQuoteCharacter(tableName), 0));
        }
    }

    private InsertValue getInsertValue(SetAssignmentsSegment sqlSegment, String sql) {
        LinkedList<SQLExpression> columnValues = new LinkedList<SQLExpression>();
        for (AssignmentSegment each : sqlSegment.getAssignments()) {
            SQLExpression sqlExpression = each.getValue().getSQLExpression(sql);
            columnValues.add(sqlExpression);
        }
        return new InsertValue(columnValues);
    }
}

