/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.encrypt.dml;

import java.util.Map;
import org.apache.shardingsphere.core.parse.antlr.filler.encrypt.dml.EncryptDeleteFromWhereFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.FromWhereSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.UpdateSetWhereSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.DMLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.EncryptColumnToken;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Column;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;

public class EncryptUpdateSetWhereFiller
extends EncryptDeleteFromWhereFiller {
    @Override
    public void fill(FromWhereSegment sqlSegment, SQLStatement sqlStatement) {
        super.fill(sqlSegment, sqlStatement);
        UpdateSetWhereSegment updateSetWhereSegment = (UpdateSetWhereSegment)sqlSegment;
        DMLStatement dmlStatement = (DMLStatement)sqlStatement;
        String updateTable = dmlStatement.getUpdateTableAlias().values().iterator().next();
        for (Map.Entry<ColumnSegment, ExpressionSegment> each : updateSetWhereSegment.getUpdateColumns().entrySet()) {
            this.fillEncryptCondition(each, updateTable, dmlStatement);
        }
        dmlStatement.setDeleteStatement(false);
    }

    private void fillEncryptCondition(Map.Entry<ColumnSegment, ExpressionSegment> entry, String updateTable, DMLStatement dmlStatement) {
        Column column = new Column(entry.getKey().getName(), updateTable);
        SQLExpression expression = entry.getValue().getSQLExpression(dmlStatement.getLogicSQL());
        dmlStatement.getUpdateColumnValues().put(column, expression);
        if (!this.getEncryptRule().getEncryptorEngine().getShardingEncryptor(column.getTableName(), column.getName()).isPresent()) {
            return;
        }
        dmlStatement.getSQLTokens().add(new EncryptColumnToken(entry.getKey().getStartIndex(), entry.getValue().getStopIndex(), column, false));
    }
}

