/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.sharding;

import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.api.ShardingRuleAwareFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.common.TableSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.old.parser.context.table.Table;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class ShardingTableFiller
implements SQLSegmentFiller<TableSegment>,
ShardingRuleAwareFiller {
    private ShardingRule shardingRule;

    @Override
    public void fill(TableSegment sqlSegment, SQLStatement sqlStatement) {
        if (this.isTableInShardingRule(sqlSegment.getName()) || !(sqlStatement instanceof SelectStatement) && sqlStatement.getTables().isEmpty()) {
            sqlStatement.getTables().add(new Table(sqlSegment.getName(), (String)sqlSegment.getAlias().orNull()));
            sqlStatement.getSQLTokens().add(sqlSegment.getToken());
        }
    }

    private boolean isTableInShardingRule(String tableName) {
        return this.shardingRule.contains(tableName) || this.shardingRule.findBindingTableRule(tableName).isPresent() || this.shardingRule.isBroadcastTable(tableName) || this.shardingRule.getShardingDataSourceNames().getDataSourceNames().contains(this.shardingRule.getShardingDataSourceNames().getDefaultDataSourceName());
    }

    @Override
    public void setShardingRule(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }
}

