/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.sharding.dml;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.constant.ShardingOperator;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.metadata.table.TableMetaData;
import org.apache.shardingsphere.core.parse.antlr.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.condition.AndConditionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.condition.ConditionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.condition.OrConditionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.SelectStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.EncryptColumnToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.TableToken;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.AndCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Column;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.OrCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.table.Table;
import org.apache.shardingsphere.core.parse.old.parser.context.table.Tables;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class OrConditionFiller
implements SQLSegmentFiller<OrConditionSegment> {
    private final ShardingRule shardingRule;
    private final ShardingTableMetaData shardingTableMetaData;

    @Override
    public void fill(OrConditionSegment sqlSegment, SQLStatement sqlStatement) {
        sqlStatement.getRouteConditions().getOrCondition().getAndConditions().addAll(this.buildCondition(sqlSegment, sqlStatement, this.shardingRule, this.shardingTableMetaData).getAndConditions());
    }

    public OrCondition buildCondition(OrConditionSegment sqlSegment, SQLStatement sqlStatement, ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        HashMap<String, String> columnNameToTable = new HashMap<String, String>();
        HashMap<String, Integer> columnNameCount = new HashMap<String, Integer>();
        this.fillColumnTableMap(sqlStatement, shardingTableMetaData, columnNameToTable, columnNameCount);
        return this.filterCondition(shardingTableMetaData, sqlStatement, sqlSegment, shardingRule);
    }

    private void fillColumnTableMap(SQLStatement sqlStatement, ShardingTableMetaData shardingTableMetaData, Map<String, String> columnNameToTable, Map<String, Integer> columnNameCount) {
        if (null == shardingTableMetaData) {
            return;
        }
        for (String each : sqlStatement.getTables().getTableNames()) {
            Collection tableColumns = shardingTableMetaData.getAllColumnNames(each);
            for (String columnName : tableColumns) {
                columnNameToTable.put(columnName, each);
                Integer count = columnNameCount.get(columnName);
                if (null == count) {
                    count = 1;
                } else {
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                }
                columnNameCount.put(columnName, count);
            }
        }
    }

    private OrCondition filterCondition(ShardingTableMetaData shardingTableMetaData, SQLStatement sqlStatement, OrConditionSegment orCondition, ShardingRule shardingRule) {
        OrCondition result = new OrCondition();
        for (AndConditionSegment each : orCondition.getAndConditions()) {
            LinkedList<ConditionSegment> shardingCondition = new LinkedList<ConditionSegment>();
            boolean needSharding = false;
            for (ConditionSegment condition : each.getConditions()) {
                if (null == condition.getColumn()) continue;
                this.addTableTokenForColumn(shardingTableMetaData, sqlStatement, condition.getColumn());
                if (condition.getExpression() instanceof ColumnSegment) {
                    this.addTableTokenForColumn(shardingTableMetaData, sqlStatement, (ColumnSegment)condition.getExpression());
                    needSharding = true;
                    continue;
                }
                Column column = new Column(condition.getColumn().getName(), this.getTableName(shardingTableMetaData, shardingRule, sqlStatement, condition));
                if (!this.isShardingCondition(condition.getOperator()) || !shardingRule.isShardingColumn(column.getName(), column.getTableName())) continue;
                shardingCondition.add(condition);
                needSharding = true;
            }
            if (needSharding) {
                this.fillResult(shardingTableMetaData, sqlStatement, shardingRule, result, shardingCondition);
                continue;
            }
            result.getAndConditions().clear();
            break;
        }
        HashSet<Integer> filledConditionStopIndexes = new HashSet<Integer>();
        for (AndConditionSegment each : orCondition.getAndConditions()) {
            for (ConditionSegment condition : each.getConditions()) {
                if (null == condition.getColumn() || condition.getExpression() instanceof ColumnSegment || filledConditionStopIndexes.contains(condition.getStopIndex())) continue;
                filledConditionStopIndexes.add(condition.getStopIndex());
                Column column = new Column(condition.getColumn().getName(), this.getTableName(shardingTableMetaData, shardingRule, sqlStatement, condition));
                this.fillEncryptCondition(column, condition, shardingRule, sqlStatement);
            }
        }
        return result;
    }

    private void addTableTokenForColumn(ShardingTableMetaData shardingTableMetaData, SQLStatement sqlStatement, ColumnSegment column) {
        if (column.getOwner().isPresent()) {
            String owner = (String)column.getOwner().get();
            Optional<Table> logicTable = sqlStatement.getTables().find(owner);
            if (logicTable.isPresent() && !((Table)logicTable.get()).getAlias().isPresent() && shardingTableMetaData.containsTable(((Table)logicTable.get()).getName())) {
                sqlStatement.addSQLToken(new TableToken(column.getStartIndex(), owner, QuoteCharacter.getQuoteCharacter(owner), 0));
            }
        }
    }

    private void fillResult(ShardingTableMetaData shardingTableMetaData, SQLStatement sqlStatement, ShardingRule shardingRule, OrCondition orCondition, List<ConditionSegment> shardingCondition) {
        if (shardingCondition.isEmpty()) {
            return;
        }
        AndCondition andConditionResult = new AndCondition();
        orCondition.getAndConditions().add(andConditionResult);
        for (ConditionSegment eachCondition : shardingCondition) {
            Optional<String> tableName = this.getTableName(sqlStatement, eachCondition);
            Column column = new Column(eachCondition.getColumn().getName(), tableName.isPresent() ? (String)tableName.get() : this.getTableName(shardingTableMetaData, shardingRule, sqlStatement, eachCondition));
            andConditionResult.getConditions().add(eachCondition.getExpression().buildCondition(column, sqlStatement.getLogicSQL()));
        }
    }

    private void fillEncryptCondition(Column column, ConditionSegment condition, ShardingRule shardingRule, SQLStatement sqlStatement) {
        AndCondition andCondition;
        if (!shardingRule.getShardingEncryptorEngine().getShardingEncryptor(column.getTableName(), column.getName()).isPresent()) {
            return;
        }
        if (0 == sqlStatement.getEncryptConditions().getOrCondition().getAndConditions().size()) {
            andCondition = new AndCondition();
            sqlStatement.getEncryptConditions().getOrCondition().getAndConditions().add(andCondition);
        } else {
            andCondition = sqlStatement.getEncryptConditions().getOrCondition().getAndConditions().get(0);
        }
        andCondition.getConditions().add(condition.getExpression().buildCondition(column, sqlStatement.getLogicSQL()));
        sqlStatement.getSQLTokens().add(new EncryptColumnToken(condition.getColumn().getStartIndex(), condition.getStopIndex(), column, true));
    }

    private boolean isShardingCondition(String operator) {
        return Symbol.EQ.getLiterals().equals(operator) || ShardingOperator.IN.name().equals(operator) || ShardingOperator.BETWEEN.name().equals(operator);
    }

    private String getTableName(ShardingTableMetaData shardingTableMetaData, ShardingRule shardingRule, SQLStatement sqlStatement, ConditionSegment conditionSegment) {
        if (!(sqlStatement instanceof SelectStatement)) {
            return this.getTableName(shardingTableMetaData, shardingRule, sqlStatement.getTables(), conditionSegment);
        }
        SelectStatement currentSelectStatement = (SelectStatement)sqlStatement;
        while (null != currentSelectStatement.getParentStatement()) {
            String tableName = this.getTableName(shardingTableMetaData, shardingRule, (currentSelectStatement = currentSelectStatement.getParentStatement()).getTables(), conditionSegment);
            if ("".equals(tableName)) continue;
            return tableName;
        }
        return this.getTableName(shardingTableMetaData, shardingRule, currentSelectStatement.getTables(), conditionSegment);
    }

    private Optional<String> getTableName(SQLStatement sqlStatement, ConditionSegment conditionSegment) {
        Optional<Table> table;
        if (conditionSegment.getColumn().getOwner().isPresent() && (table = sqlStatement.getTables().find((String)conditionSegment.getColumn().getOwner().get())).isPresent()) {
            return Optional.of((Object)((Table)table.get()).getName());
        }
        return Optional.absent();
    }

    private String getTableName(ShardingTableMetaData shardingTableMetaData, ShardingRule shardingRule, Tables tables, ConditionSegment conditionSegment) {
        Collection shardingLogicTableNames = shardingRule.getShardingLogicTableNames(tables.getTableNames());
        if (tables.isSingleTable() || tables.isSameTable() || 1 == shardingLogicTableNames.size() || shardingRule.isAllBindingTables(shardingLogicTableNames)) {
            return tables.getSingleTableName();
        }
        if (conditionSegment.getColumn().getOwner().isPresent()) {
            Optional<Table> table = tables.find((String)conditionSegment.getColumn().getOwner().get());
            return table.isPresent() ? ((Table)table.get()).getName() : "";
        }
        return this.getTableNameFromMetaData(shardingTableMetaData, tables, conditionSegment.getColumn().getName());
    }

    private String getTableNameFromMetaData(ShardingTableMetaData shardingTableMetaData, Tables tables, String columnName) {
        for (String each : tables.getTableNames()) {
            TableMetaData tableMetaData = shardingTableMetaData.get(each);
            if (null == tableMetaData || !tableMetaData.getColumns().containsKey(columnName)) continue;
            return each;
        }
        return "";
    }

    @ConstructorProperties(value={"shardingRule", "shardingTableMetaData"})
    public OrConditionFiller(ShardingRule shardingRule, ShardingTableMetaData shardingTableMetaData) {
        this.shardingRule = shardingRule;
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

