/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.sharding.dml;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.constant.QuoteCharacter;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.api.ShardingRuleAwareFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.api.ShardingTableMetaDataAwareFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.assignment.AssignmentSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.assignment.SetAssignmentsSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.CommonExpressionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.InsertSetToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.TableToken;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.AndCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Column;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Condition;
import org.apache.shardingsphere.core.parse.old.parser.context.insertvalue.InsertValue;
import org.apache.shardingsphere.core.parse.old.parser.exception.SQLParsingException;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLNumberExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPlaceholderExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLTextExpression;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class SetAssignmentsFiller
implements SQLSegmentFiller<SetAssignmentsSegment>,
ShardingRuleAwareFiller,
ShardingTableMetaDataAwareFiller {
    private ShardingRule shardingRule;
    private ShardingTableMetaData shardingTableMetaData;

    @Override
    public void fill(SetAssignmentsSegment sqlSegment, SQLStatement sqlStatement) {
        InsertStatement insertStatement = (InsertStatement)sqlStatement;
        String tableName = insertStatement.getTables().getSingleTableName();
        for (AssignmentSegment each : sqlSegment.getAssignments()) {
            this.fillColumn(each.getColumn(), insertStatement, tableName);
        }
        int columnCount = this.getColumnCountExcludeAssistedQueryColumns(insertStatement);
        if (sqlSegment.getAssignments().size() != columnCount) {
            throw new SQLParsingException("INSERT INTO column size mismatch value size.", new Object[0]);
        }
        AndCondition andCondition = new AndCondition();
        Iterator<String> columnNames = insertStatement.getColumnNames().iterator();
        LinkedList<SQLExpression> columnValues = new LinkedList<SQLExpression>();
        for (AssignmentSegment each : sqlSegment.getAssignments()) {
            SQLExpression columnValue = this.getColumnValue(insertStatement, andCondition, columnNames.next(), each.getValue());
            columnValues.add(columnValue);
        }
        InsertValue insertValue = new InsertValue(columnValues);
        insertStatement.getValues().add(insertValue);
        insertStatement.getRouteConditions().getOrCondition().getAndConditions().add(andCondition);
        insertStatement.setParametersIndex(insertValue.getParametersCount());
        insertStatement.getSQLTokens().add(new InsertSetToken(sqlSegment.getStartIndex()));
    }

    private void fillColumn(ColumnSegment sqlSegment, InsertStatement insertStatement, String tableName) {
        insertStatement.getColumnNames().add(sqlSegment.getName());
        if (sqlSegment.getOwner().isPresent() && tableName.equals(sqlSegment.getOwner().get())) {
            insertStatement.getSQLTokens().add(new TableToken(sqlSegment.getStartIndex(), tableName, QuoteCharacter.getQuoteCharacter(tableName), 0));
        }
    }

    private int getColumnCountExcludeAssistedQueryColumns(InsertStatement insertStatement) {
        String tableName = insertStatement.getTables().getSingleTableName();
        if (this.shardingTableMetaData.containsTable(tableName) && this.shardingTableMetaData.get(tableName).getColumns().size() == insertStatement.getColumnNames().size()) {
            return insertStatement.getColumnNames().size();
        }
        Integer assistedQueryColumnCount = this.shardingRule.getShardingEncryptorEngine().getAssistedQueryColumnCount(insertStatement.getTables().getSingleTableName());
        return insertStatement.getColumnNames().size() - assistedQueryColumnCount;
    }

    private SQLExpression getColumnValue(InsertStatement insertStatement, AndCondition andCondition, String columnName, CommonExpressionSegment expressionSegment) {
        SQLExpression result = expressionSegment.getSQLExpression(insertStatement.getLogicSQL());
        String tableName = insertStatement.getTables().getSingleTableName();
        this.fillShardingCondition(andCondition, columnName, tableName, result);
        return result;
    }

    private void fillShardingCondition(AndCondition andCondition, String columnName, String tableName, SQLExpression sqlExpression) {
        if (this.shardingRule.isShardingColumn(columnName, tableName)) {
            if (sqlExpression instanceof SQLPlaceholderExpression || sqlExpression instanceof SQLNumberExpression || sqlExpression instanceof SQLTextExpression) {
                andCondition.getConditions().add(new Condition(new Column(columnName, tableName), sqlExpression));
            } else {
                throw new SQLParsingException("INSERT INTO can not support complex expression value on sharding column '%s'.", columnName);
            }
        }
    }

    @Override
    public void setShardingRule(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }

    @Override
    public void setShardingTableMetaData(ShardingTableMetaData shardingTableMetaData) {
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

