/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.filler.sharding.dml.insert;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.filler.api.ShardingRuleAwareFiller;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.InsertValuesSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.CommonExpressionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.InsertStatement;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.AndCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Column;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Condition;
import org.apache.shardingsphere.core.parse.old.parser.context.insertvalue.InsertValue;
import org.apache.shardingsphere.core.parse.old.parser.exception.SQLParsingException;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLNumberExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPlaceholderExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLTextExpression;
import org.apache.shardingsphere.core.rule.ShardingRule;

public final class InsertValuesFiller
implements SQLSegmentFiller<InsertValuesSegment>,
ShardingRuleAwareFiller {
    private ShardingRule shardingRule;

    @Override
    public void fill(InsertValuesSegment sqlSegment, SQLStatement sqlStatement) {
        InsertStatement insertStatement = (InsertStatement)sqlStatement;
        AndCondition andCondition = new AndCondition();
        Iterator<String> columnNames = this.getColumnNames(sqlSegment, insertStatement);
        LinkedList<SQLExpression> columnValues = new LinkedList<SQLExpression>();
        for (CommonExpressionSegment each : sqlSegment.getValues()) {
            String columnName = columnNames.next();
            SQLExpression columnValue = this.getColumnValue(insertStatement, andCondition, columnName, each);
            columnValues.add(columnValue);
        }
        insertStatement.getRouteConditions().getOrCondition().getAndConditions().add(andCondition);
        InsertValue insertValue = new InsertValue(columnValues);
        insertStatement.getValues().add(insertValue);
        insertStatement.setParametersIndex(insertStatement.getParametersIndex() + insertValue.getParametersCount());
    }

    private Iterator<String> getColumnNames(InsertValuesSegment sqlSegment, InsertStatement insertStatement) {
        ArrayList<String> result = new ArrayList<String>(insertStatement.getColumnNames());
        Optional generateKeyColumnName = this.shardingRule.findGenerateKeyColumnName(insertStatement.getTables().getSingleTableName());
        if (insertStatement.getColumnNames().size() != sqlSegment.getValues().size() && generateKeyColumnName.isPresent()) {
            result.remove(generateKeyColumnName.get());
        }
        return result.iterator();
    }

    private SQLExpression getColumnValue(InsertStatement insertStatement, AndCondition andCondition, String columnName, CommonExpressionSegment expressionSegment) {
        SQLExpression result = expressionSegment.getSQLExpression(insertStatement.getLogicSQL());
        String tableName = insertStatement.getTables().getSingleTableName();
        this.fillShardingCondition(andCondition, tableName, columnName, result);
        return result;
    }

    private void fillShardingCondition(AndCondition andCondition, String tableName, String columnName, SQLExpression sqlExpression) {
        if (this.shardingRule.isShardingColumn(columnName, tableName)) {
            if (sqlExpression instanceof SQLPlaceholderExpression || sqlExpression instanceof SQLNumberExpression || sqlExpression instanceof SQLTextExpression) {
                andCondition.getConditions().add(new Condition(new Column(columnName, tableName), sqlExpression));
            } else {
                throw new SQLParsingException("INSERT INTO can not support complex expression value on sharding column '%s'.", columnName);
            }
        }
    }

    @Override
    public void setShardingRule(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }
}

