/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.optimizer;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.optimizer.SQLStatementOptimizer;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.statement.SQLStatementRule;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;

public final class SQLStatementOptimizerEngine {
    private final ShardingTableMetaData shardingTableMetaData;

    public void optimize(SQLStatementRule rule, SQLStatement sqlStatement) {
        Optional<SQLStatementOptimizer> optimizer = rule.getOptimizer();
        if (optimizer.isPresent()) {
            ((SQLStatementOptimizer)optimizer.get()).optimize(sqlStatement, this.shardingTableMetaData);
        }
    }

    @ConstructorProperties(value={"shardingTableMetaData"})
    public SQLStatementOptimizerEngine(ShardingTableMetaData shardingTableMetaData) {
        this.shardingTableMetaData = shardingTableMetaData;
    }
}

