/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.parser;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.parse.antlr.parser.SQLAST;
import org.apache.shardingsphere.core.parse.antlr.parser.SQLParserFactory;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.EncryptParsingRuleRegistry;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.ParsingRuleRegistry;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.statement.SQLStatementRule;
import org.apache.shardingsphere.core.parse.old.parser.exception.SQLParsingUnsupportedException;

public final class SQLParserEngine {
    private final ParsingRuleRegistry parsingRuleRegistry;
    private final DatabaseType databaseType;
    private final String sql;

    public SQLAST parse() {
        ParseTree parseTree = SQLParserFactory.newInstance(this.databaseType, this.sql).execute().getChild(0);
        if (parseTree instanceof ErrorNode) {
            throw new SQLParsingUnsupportedException(String.format("Unsupported SQL of `%s`", this.sql));
        }
        Optional<SQLStatementRule> sqlStatementRule = this.parsingRuleRegistry.findSQLStatementRule(this.databaseType, parseTree.getClass().getSimpleName());
        if (sqlStatementRule.isPresent()) {
            return new SQLAST((ParserRuleContext)parseTree, (SQLStatementRule)sqlStatementRule.get());
        }
        if (this.parsingRuleRegistry instanceof EncryptParsingRuleRegistry) {
            return new SQLAST((ParserRuleContext)parseTree);
        }
        throw new SQLParsingUnsupportedException(String.format("Unsupported SQL of `%s`", this.sql));
    }

    @ConstructorProperties(value={"parsingRuleRegistry", "databaseType", "sql"})
    public SQLParserEngine(ParsingRuleRegistry parsingRuleRegistry, DatabaseType databaseType, String sql) {
        this.parsingRuleRegistry = parsingRuleRegistry;
        this.databaseType = databaseType;
        this.sql = sql;
    }
}

