/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.parser;

import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.parse.api.SQLParser;
import org.apache.shardingsphere.core.parse.spi.ShardingParseEngine;
import org.apache.shardingsphere.core.spi.NewInstanceServiceLoader;

public final class SQLParserFactory {
    public static SQLParser newInstance(DatabaseType databaseType, String sql) {
        for (ShardingParseEngine each : NewInstanceServiceLoader.newServiceInstances(ShardingParseEngine.class)) {
            if (DatabaseType.valueOf((String)each.getDatabaseType()) != databaseType) continue;
            return each.createSQLParser(sql);
        }
        throw new UnsupportedOperationException(String.format("Cannot support database type '%s'", databaseType));
    }

    private SQLParserFactory() {
    }

    static {
        NewInstanceServiceLoader.register(ShardingParseEngine.class);
    }
}

