/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.rule.jaxb.loader;

import com.google.common.base.Joiner;
import org.apache.shardingsphere.core.constant.DatabaseType;

public final class RuleDefinitionFileConstant {
    public static final String ROOT_PATH = "META-INF/parsing-rule-definition";
    public static final String SHARDING_ROOT_PATH = "META-INF/parsing-rule-definition/sharding";
    public static final String ENCRYPT_ROOT_PATH = "META-INF/parsing-rule-definition/encrypt";
    private static final String COMMON = "common";
    private static final String SQL_STATEMENT_RULE_DEFINITION_FILE_NAME = "sql-statement-rule-definition.xml";
    private static final String EXTRACTOR_RULE_DEFINITION_FILE_NAME = "extractor-rule-definition.xml";
    private static final String FILLER_DEFINITION_FILE_NAME = "filler-rule-definition.xml";

    public static String getSQLStatementRuleDefinitionFileName(String rootDir, DatabaseType databaseType) {
        return Joiner.on((char)'/').join((Object)rootDir, (Object)databaseType.name().toLowerCase(), new Object[]{SQL_STATEMENT_RULE_DEFINITION_FILE_NAME});
    }

    public static String getExtractorRuleDefinitionFileName(String rootDir, DatabaseType databaseType) {
        return Joiner.on((char)'/').join((Object)rootDir, (Object)databaseType.name().toLowerCase(), new Object[]{EXTRACTOR_RULE_DEFINITION_FILE_NAME});
    }

    public static String getFillerRuleDefinitionFileName(String rootDir, DatabaseType databaseType) {
        return Joiner.on((char)'/').join((Object)rootDir, (Object)databaseType.name().toLowerCase(), new Object[]{FILLER_DEFINITION_FILE_NAME});
    }

    public static String getShardingCommonFillerRuleDefinitionFileName() {
        return Joiner.on((char)'/').join((Object)SHARDING_ROOT_PATH, (Object)COMMON, new Object[]{FILLER_DEFINITION_FILE_NAME});
    }

    public static String getCommonExtractorRuleDefinitionFileName() {
        return Joiner.on((char)'/').join((Object)ROOT_PATH, (Object)COMMON, new Object[]{EXTRACTOR_RULE_DEFINITION_FILE_NAME});
    }

    public static String getCommonFillerRuleDefinitionFileName() {
        return Joiner.on((char)'/').join((Object)ROOT_PATH, (Object)COMMON, new Object[]{FILLER_DEFINITION_FILE_NAME});
    }

    private RuleDefinitionFileConstant() {
    }
}

