/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.rule.registry;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.parse.antlr.filler.api.SQLSegmentFiller;
import org.apache.shardingsphere.core.parse.antlr.rule.jaxb.loader.RuleDefinitionFileConstant;
import org.apache.shardingsphere.core.parse.antlr.rule.jaxb.loader.extractor.ExtractorRuleDefinitionEntityLoader;
import org.apache.shardingsphere.core.parse.antlr.rule.jaxb.loader.filler.FillerRuleDefinitionEntityLoader;
import org.apache.shardingsphere.core.parse.antlr.rule.jaxb.loader.statement.SQLStatementRuleDefinitionEntityLoader;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.ParserRuleDefinition;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.statement.SQLStatementRule;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.SQLSegment;

public abstract class ParsingRuleRegistry {
    private final SQLStatementRuleDefinitionEntityLoader statementRuleDefinitionLoader = new SQLStatementRuleDefinitionEntityLoader();
    private final ExtractorRuleDefinitionEntityLoader extractorRuleDefinitionLoader = new ExtractorRuleDefinitionEntityLoader();
    private final FillerRuleDefinitionEntityLoader fillerRuleDefinitionLoader = new FillerRuleDefinitionEntityLoader();
    private final ParserRuleDefinition commonRuleDefinition = new ParserRuleDefinition();
    private final Map<DatabaseType, ParserRuleDefinition> parserRuleDefinitions = new HashMap<DatabaseType, ParserRuleDefinition>(4, 1.0f);

    protected final void init() {
        this.initCommonParserRuleDefinition();
        this.initParserRuleDefinition();
    }

    private void initCommonParserRuleDefinition() {
        List<String> fillerFilePaths = Collections.singletonList(RuleDefinitionFileConstant.getCommonFillerRuleDefinitionFileName());
        List<String> extractorFilePaths = Collections.singletonList(RuleDefinitionFileConstant.getCommonExtractorRuleDefinitionFileName());
        this.initParserRuleDefinition(this.commonRuleDefinition, fillerFilePaths, extractorFilePaths, new ArrayList<String>());
    }

    private void initParserRuleDefinition() {
        for (DatabaseType each : DatabaseType.values()) {
            if (DatabaseType.H2 == each || !this.needParser(each)) continue;
            LinkedList<String> fillerFilePaths = new LinkedList<String>();
            LinkedList<String> extractorFilePaths = new LinkedList<String>();
            LinkedList<String> sqlStateRuleFilePaths = new LinkedList<String>();
            this.fillRuleFilePaths(each, fillerFilePaths, extractorFilePaths, sqlStateRuleFilePaths);
            ParserRuleDefinition shardingRuleDefinition = new ParserRuleDefinition();
            this.initParserRuleDefinitionFromCommon(shardingRuleDefinition, fillerFilePaths, extractorFilePaths, sqlStateRuleFilePaths);
            this.parserRuleDefinitions.put(each, shardingRuleDefinition);
        }
    }

    protected boolean needParser(DatabaseType databaseType) {
        return true;
    }

    protected abstract void fillRuleFilePaths(DatabaseType var1, Collection<String> var2, Collection<String> var3, Collection<String> var4);

    private void initParserRuleDefinitionFromCommon(ParserRuleDefinition parserRuleDefinition, Collection<String> fillerFilePaths, Collection<String> extractorFilePaths, Collection<String> sqlStateRuleFilePaths) {
        parserRuleDefinition.getExtractorRuleDefinition().getRules().putAll(this.commonRuleDefinition.getExtractorRuleDefinition().getRules());
        parserRuleDefinition.getFillerRuleDefinition().getRules().putAll(this.commonRuleDefinition.getFillerRuleDefinition().getRules());
        this.initParserRuleDefinition(parserRuleDefinition, fillerFilePaths, extractorFilePaths, sqlStateRuleFilePaths);
    }

    private void initParserRuleDefinition(ParserRuleDefinition parserRuleDefinition, Collection<String> fillerFilePaths, Collection<String> extractorFilePaths, Collection<String> sqlStateRuleFilePaths) {
        for (String each : fillerFilePaths) {
            parserRuleDefinition.getFillerRuleDefinition().init(this.fillerRuleDefinitionLoader.load(each));
        }
        for (String each : extractorFilePaths) {
            parserRuleDefinition.getExtractorRuleDefinition().init(this.extractorRuleDefinitionLoader.load(each));
        }
        for (String each : sqlStateRuleFilePaths) {
            parserRuleDefinition.getSqlStatementRuleDefinition().init(this.statementRuleDefinitionLoader.load(each), parserRuleDefinition.getExtractorRuleDefinition());
        }
    }

    public Optional<SQLStatementRule> findSQLStatementRule(DatabaseType databaseType, String contextClassName) {
        return Optional.fromNullable((Object)this.parserRuleDefinitions.get(DatabaseType.H2 == databaseType ? DatabaseType.MySQL : databaseType).getSqlStatementRuleDefinition().getRules().get(contextClassName));
    }

    public Optional<SQLSegmentFiller> findSQLSegmentFiller(DatabaseType databaseType, Class<? extends SQLSegment> sqlSegmentClass) {
        return Optional.fromNullable((Object)this.parserRuleDefinitions.get(DatabaseType.H2 == databaseType ? DatabaseType.MySQL : databaseType).getFillerRuleDefinition().getRules().get(sqlSegmentClass));
    }
}

