/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.rule.registry;

import java.util.Collection;
import org.apache.shardingsphere.core.constant.DatabaseType;
import org.apache.shardingsphere.core.parse.antlr.rule.jaxb.loader.RuleDefinitionFileConstant;
import org.apache.shardingsphere.core.parse.antlr.rule.registry.ParsingRuleRegistry;

public class ShardingParsingRuleRegistry
extends ParsingRuleRegistry {
    private static volatile ParsingRuleRegistry instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ParsingRuleRegistry getInstance() {
        if (null != instance) return instance;
        Class<ShardingParsingRuleRegistry> clazz = ShardingParsingRuleRegistry.class;
        synchronized (ShardingParsingRuleRegistry.class) {
            if (null != instance) return instance;
            instance = new ShardingParsingRuleRegistry();
            instance.init();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected void fillRuleFilePaths(DatabaseType databaseType, Collection<String> fillerFilePaths, Collection<String> extractorFilePaths, Collection<String> sqlStateRuleFilePaths) {
        fillerFilePaths.add(RuleDefinitionFileConstant.getShardingCommonFillerRuleDefinitionFileName());
        if (DatabaseType.MySQL == databaseType) {
            fillerFilePaths.add(RuleDefinitionFileConstant.getFillerRuleDefinitionFileName("META-INF/parsing-rule-definition/sharding", databaseType));
        }
        extractorFilePaths.add(RuleDefinitionFileConstant.getExtractorRuleDefinitionFileName("META-INF/parsing-rule-definition/sharding", databaseType));
        sqlStateRuleFilePaths.add(RuleDefinitionFileConstant.getSQLStatementRuleDefinitionFileName("META-INF/parsing-rule-definition/sharding", databaseType));
    }

    private ShardingParsingRuleRegistry() {
    }
}

