/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.sql.segment.common;

import com.google.common.base.Optional;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.SQLSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.token.TableToken;
import org.apache.shardingsphere.core.parse.util.SQLUtil;

public class TableSegment
implements SQLSegment {
    private final TableToken token;
    private final String schemaName;
    private final String alias;

    public TableSegment(TableToken token, String schemaName, String alias) {
        this.token = token;
        this.schemaName = SQLUtil.getExactlyValue(schemaName);
        this.alias = alias;
    }

    public String getName() {
        return this.token.getTableName();
    }

    public Optional<String> getSchemaName() {
        return Optional.fromNullable((Object)this.schemaName);
    }

    public Optional<String> getAlias() {
        return Optional.fromNullable((Object)this.alias);
    }

    public TableToken getToken() {
        return this.token;
    }
}

