/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.column;

import com.google.common.base.Optional;
import org.apache.shardingsphere.core.parse.antlr.sql.OwnerAvailable;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.SQLRightValueExpressionSegment;
import org.apache.shardingsphere.core.parse.old.lexer.token.Symbol;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Column;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Condition;
import org.apache.shardingsphere.core.parse.util.SQLUtil;

public class ColumnSegment
implements SQLRightValueExpressionSegment,
OwnerAvailable {
    private final String name;
    private final String owner;
    private final int startIndex;
    private final int stopIndex;

    public ColumnSegment(String name, int startIndex, int stopIndex) {
        this(name, null, startIndex, stopIndex);
    }

    public ColumnSegment(String name, String owner, int startIndex, int stopIndex) {
        this.name = SQLUtil.getExactlyValue(name);
        this.owner = SQLUtil.getExactlyValue(owner);
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
    }

    public final String getQualifiedName() {
        return null == this.owner ? this.name : this.owner + Symbol.DOT.getLiterals() + this.name;
    }

    @Override
    public final Optional<String> getOwner() {
        return Optional.fromNullable((Object)this.owner);
    }

    @Override
    public Condition buildCondition(Column column, String sql) {
        throw new RuntimeException("Unsupported right column segment to condition ");
    }

    public String getName() {
        return this.name;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getStopIndex() {
        return this.stopIndex;
    }
}

