/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr;

import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLNumberExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPlaceholderExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLTextExpression;

public final class CommonExpressionSegment
implements ExpressionSegment {
    private final int startIndex;
    private final int stopIndex;
    private int placeholderIndex = -1;
    private Object literals;

    @Override
    public SQLExpression getSQLExpression(String sql) {
        if (-1 != this.placeholderIndex) {
            return new SQLPlaceholderExpression(this.placeholderIndex);
        }
        if (this.literals instanceof Number) {
            return new SQLNumberExpression((Number)this.literals);
        }
        if (this.literals instanceof String) {
            return new SQLTextExpression(this.literals.toString());
        }
        return new SQLTextExpression(sql.substring(this.startIndex, this.stopIndex + 1));
    }

    @ConstructorProperties(value={"startIndex", "stopIndex"})
    public CommonExpressionSegment(int startIndex, int stopIndex) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getStopIndex() {
        return this.stopIndex;
    }

    public int getPlaceholderIndex() {
        return this.placeholderIndex;
    }

    public Object getLiterals() {
        return this.literals;
    }

    public void setPlaceholderIndex(int placeholderIndex) {
        this.placeholderIndex = placeholderIndex;
    }

    public void setLiterals(Object literals) {
        this.literals = literals;
    }
}

