/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr;

import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLIgnoreExpression;

public final class FunctionExpressionSegment
implements ExpressionSegment {
    private final int startIndex;
    private final int stopIndex;
    private final String functionName;
    private final int innerExpressionStartIndex;
    private final int innerExpressionStopIndex;
    private final int distinctExpressionStartIndex;

    @Override
    public SQLExpression getSQLExpression(String sql) {
        return new SQLIgnoreExpression(sql.substring(this.startIndex, this.startIndex + 1));
    }

    @ConstructorProperties(value={"startIndex", "stopIndex", "functionName", "innerExpressionStartIndex", "innerExpressionStopIndex", "distinctExpressionStartIndex"})
    public FunctionExpressionSegment(int startIndex, int stopIndex, String functionName, int innerExpressionStartIndex, int innerExpressionStopIndex, int distinctExpressionStartIndex) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.functionName = functionName;
        this.innerExpressionStartIndex = innerExpressionStartIndex;
        this.innerExpressionStopIndex = innerExpressionStopIndex;
        this.distinctExpressionStartIndex = distinctExpressionStartIndex;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getStopIndex() {
        return this.stopIndex;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public int getInnerExpressionStartIndex() {
        return this.innerExpressionStartIndex;
    }

    public int getInnerExpressionStopIndex() {
        return this.innerExpressionStopIndex;
    }

    public int getDistinctExpressionStartIndex() {
        return this.distinctExpressionStartIndex;
    }
}

