/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLIdentifierExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLPropertyExpression;

public final class PropertyExpressionSegment
implements ExpressionSegment {
    private final int startIndex;
    private final int stopIndex;
    private final String name;
    private final String owner;

    public Optional<String> getOwner() {
        return Optional.fromNullable((Object)this.owner);
    }

    @Override
    public SQLExpression getSQLExpression(String sql) {
        return new SQLPropertyExpression(null == this.owner ? null : new SQLIdentifierExpression(this.owner), this.name);
    }

    @ConstructorProperties(value={"startIndex", "stopIndex", "name", "owner"})
    public PropertyExpressionSegment(int startIndex, int stopIndex, String name, String owner) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.name = name;
        this.owner = owner;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getStopIndex() {
        return this.stopIndex;
    }

    public String getName() {
        return this.name;
    }
}

