/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import org.apache.shardingsphere.core.parse.antlr.sql.AliasAvailable;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.FromWhereSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.SelectClauseSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.item.SelectItemSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.order.GroupBySegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.dml.order.OrderBySegment;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLIgnoreExpression;
import org.apache.shardingsphere.core.parse.util.SQLUtil;

public final class SubquerySegment
implements SelectItemSegment,
ExpressionSegment,
AliasAvailable {
    private final int startIndex;
    private final int stopIndex;
    private final boolean subqueryInFrom;
    private SelectClauseSegment selectClauseSegment;
    private FromWhereSegment fromWhereSegment;
    private GroupBySegment groupBySegment;
    private OrderBySegment orderBySegment;
    private String alias;

    public Optional<SelectClauseSegment> getSelectClauseSegment() {
        return Optional.fromNullable((Object)this.selectClauseSegment);
    }

    public Optional<FromWhereSegment> getFromWhereSegment() {
        return Optional.fromNullable((Object)this.fromWhereSegment);
    }

    public Optional<GroupBySegment> getGroupBySegment() {
        return Optional.fromNullable((Object)this.groupBySegment);
    }

    public Optional<OrderBySegment> getOrderBySegment() {
        return Optional.fromNullable((Object)this.orderBySegment);
    }

    @Override
    public Optional<String> getAlias() {
        return Optional.fromNullable((Object)this.alias);
    }

    @Override
    public void setAlias(String alias) {
        this.alias = SQLUtil.getExactlyValue(alias);
    }

    @Override
    public SQLExpression getSQLExpression(String sql) {
        return new SQLIgnoreExpression(sql.substring(this.startIndex, this.startIndex + 1));
    }

    @ConstructorProperties(value={"startIndex", "stopIndex", "subqueryInFrom"})
    public SubquerySegment(int startIndex, int stopIndex, boolean subqueryInFrom) {
        this.startIndex = startIndex;
        this.stopIndex = stopIndex;
        this.subqueryInFrom = subqueryInFrom;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public int getStopIndex() {
        return this.stopIndex;
    }

    public boolean isSubqueryInFrom() {
        return this.subqueryInFrom;
    }

    public void setSelectClauseSegment(SelectClauseSegment selectClauseSegment) {
        this.selectClauseSegment = selectClauseSegment;
    }

    public void setFromWhereSegment(FromWhereSegment fromWhereSegment) {
        this.fromWhereSegment = fromWhereSegment;
    }

    public void setGroupBySegment(GroupBySegment groupBySegment) {
        this.groupBySegment = groupBySegment;
    }

    public void setOrderBySegment(OrderBySegment orderBySegment) {
        this.orderBySegment = orderBySegment;
    }
}

