/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.sql.statement;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.shardingsphere.core.constant.SQLType;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.SQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.SQLToken;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Conditions;
import org.apache.shardingsphere.core.parse.old.parser.context.table.Tables;

public abstract class AbstractSQLStatement
implements SQLStatement {
    private final SQLType type;
    private final Tables tables = new Tables();
    private final Conditions routeConditions = new Conditions();
    private final Conditions encryptConditions = new Conditions();
    private final List<SQLToken> sqlTokens = new LinkedList<SQLToken>();
    private int parametersIndex;
    private String logicSQL;

    @Override
    public final void addSQLToken(SQLToken sqlToken) {
        this.sqlTokens.add(sqlToken);
    }

    @Override
    public final <T extends SQLToken> Optional<T> findSQLToken(Class<T> sqlTokenType) {
        for (SQLToken each : this.sqlTokens) {
            if (!each.getClass().equals(sqlTokenType)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    @Override
    public final List<SQLToken> getSQLTokens() {
        Collections.sort(this.sqlTokens);
        return this.sqlTokens;
    }

    @Override
    public final void increaseParametersIndex() {
        ++this.parametersIndex;
    }

    @ConstructorProperties(value={"type"})
    public AbstractSQLStatement(SQLType type) {
        this.type = type;
    }

    @Override
    public SQLType getType() {
        return this.type;
    }

    @Override
    public Tables getTables() {
        return this.tables;
    }

    @Override
    public Conditions getRouteConditions() {
        return this.routeConditions;
    }

    @Override
    public Conditions getEncryptConditions() {
        return this.encryptConditions;
    }

    @Override
    public int getParametersIndex() {
        return this.parametersIndex;
    }

    @Override
    public String getLogicSQL() {
        return this.logicSQL;
    }

    public void setParametersIndex(int parametersIndex) {
        this.parametersIndex = parametersIndex;
    }

    @Override
    public void setLogicSQL(String logicSQL) {
        this.logicSQL = logicSQL;
    }

    public String toString() {
        return "AbstractSQLStatement(type=" + this.getType() + ", tables=" + this.getTables() + ", routeConditions=" + this.getRouteConditions() + ", encryptConditions=" + this.getEncryptConditions() + ", sqlTokens=" + this.getSQLTokens() + ", parametersIndex=" + this.getParametersIndex() + ", logicSQL=" + this.getLogicSQL() + ")";
    }
}

