/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl;

import com.google.common.base.Optional;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import org.apache.shardingsphere.core.metadata.table.ColumnMetaData;
import org.apache.shardingsphere.core.metadata.table.ShardingTableMetaData;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.segment.ddl.column.position.ColumnPositionSegment;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.ddl.DDLStatement;

public final class AlterTableStatement
extends DDLStatement {
    private final Collection<ColumnDefinitionSegment> addedColumnDefinitions = new LinkedList<ColumnDefinitionSegment>();
    private final Map<String, ColumnDefinitionSegment> modifiedColumnDefinitions = new LinkedHashMap<String, ColumnDefinitionSegment>();
    private final Collection<ColumnPositionSegment> changedPositionColumns = new TreeSet<ColumnPositionSegment>();
    private final Collection<String> droppedColumnNames = new LinkedList<String>();
    private boolean dropPrimaryKey;
    private String newTableName;

    public Optional<String> getNewTableName() {
        return Optional.fromNullable((Object)this.newTableName);
    }

    public Optional<ColumnDefinitionSegment> findColumnDefinition(String columnName, ShardingTableMetaData shardingTableMetaData) {
        Optional<ColumnDefinitionSegment> result = this.findColumnDefinitionFromMetaData(columnName, shardingTableMetaData);
        return result.isPresent() ? result : this.findColumnDefinitionFromCurrentAddClause(columnName);
    }

    public Optional<ColumnDefinitionSegment> findColumnDefinitionFromMetaData(String columnName, ShardingTableMetaData shardingTableMetaData) {
        if (!shardingTableMetaData.containsTable(this.getTables().getSingleTableName())) {
            return Optional.absent();
        }
        for (ColumnMetaData each : shardingTableMetaData.get(this.getTables().getSingleTableName()).getColumns().values()) {
            if (!columnName.equalsIgnoreCase(each.getColumnName())) continue;
            return Optional.of((Object)new ColumnDefinitionSegment(columnName, each.getDataType(), each.isPrimaryKey()));
        }
        return Optional.absent();
    }

    private Optional<ColumnDefinitionSegment> findColumnDefinitionFromCurrentAddClause(String columnName) {
        for (ColumnDefinitionSegment each : this.addedColumnDefinitions) {
            if (!each.getColumnName().equalsIgnoreCase(columnName)) continue;
            return Optional.of((Object)each);
        }
        return Optional.absent();
    }

    public Collection<ColumnDefinitionSegment> getAddedColumnDefinitions() {
        return this.addedColumnDefinitions;
    }

    public Map<String, ColumnDefinitionSegment> getModifiedColumnDefinitions() {
        return this.modifiedColumnDefinitions;
    }

    public Collection<ColumnPositionSegment> getChangedPositionColumns() {
        return this.changedPositionColumns;
    }

    public Collection<String> getDroppedColumnNames() {
        return this.droppedColumnNames;
    }

    public boolean isDropPrimaryKey() {
        return this.dropPrimaryKey;
    }

    public void setDropPrimaryKey(boolean dropPrimaryKey) {
        this.dropPrimaryKey = dropPrimaryKey;
    }

    public void setNewTableName(String newTableName) {
        this.newTableName = newTableName;
    }
}

