/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.sql.statement.dml;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.shardingsphere.core.constant.SQLType;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.AbstractSQLStatement;
import org.apache.shardingsphere.core.parse.old.lexer.token.DefaultKeyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.Keyword;
import org.apache.shardingsphere.core.parse.old.lexer.token.TokenType;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.Column;
import org.apache.shardingsphere.core.parse.old.parser.expression.SQLExpression;

public class DMLStatement
extends AbstractSQLStatement {
    private static final Collection<Keyword> STATEMENT_PREFIX = Arrays.asList(DefaultKeyword.INSERT, DefaultKeyword.UPDATE, DefaultKeyword.DELETE);
    private boolean deleteStatement;
    private final Map<String, String> updateTableAlias = new HashMap<String, String>();
    private final Map<Column, SQLExpression> updateColumnValues = new LinkedHashMap<Column, SQLExpression>();
    private int whereStartIndex;
    private int whereStopIndex;
    private int whereParameterStartIndex;
    private int whereParameterEndIndex;

    public DMLStatement() {
        super(SQLType.DML);
    }

    public static boolean isDML(TokenType tokenType) {
        return STATEMENT_PREFIX.contains(tokenType);
    }

    @Override
    public String toString() {
        return "DMLStatement(super=" + super.toString() + ", deleteStatement=" + this.isDeleteStatement() + ", updateTableAlias=" + this.getUpdateTableAlias() + ", updateColumnValues=" + this.getUpdateColumnValues() + ", whereStartIndex=" + this.getWhereStartIndex() + ", whereStopIndex=" + this.getWhereStopIndex() + ", whereParameterStartIndex=" + this.getWhereParameterStartIndex() + ", whereParameterEndIndex=" + this.getWhereParameterEndIndex() + ")";
    }

    public boolean isDeleteStatement() {
        return this.deleteStatement;
    }

    public Map<String, String> getUpdateTableAlias() {
        return this.updateTableAlias;
    }

    public Map<Column, SQLExpression> getUpdateColumnValues() {
        return this.updateColumnValues;
    }

    public int getWhereStartIndex() {
        return this.whereStartIndex;
    }

    public int getWhereStopIndex() {
        return this.whereStopIndex;
    }

    public int getWhereParameterStartIndex() {
        return this.whereParameterStartIndex;
    }

    public int getWhereParameterEndIndex() {
        return this.whereParameterEndIndex;
    }

    public void setDeleteStatement(boolean deleteStatement) {
        this.deleteStatement = deleteStatement;
    }

    public void setWhereStartIndex(int whereStartIndex) {
        this.whereStartIndex = whereStartIndex;
    }

    public void setWhereStopIndex(int whereStopIndex) {
        this.whereStopIndex = whereStopIndex;
    }

    public void setWhereParameterStartIndex(int whereParameterStartIndex) {
        this.whereParameterStartIndex = whereParameterStartIndex;
    }

    public void setWhereParameterEndIndex(int whereParameterEndIndex) {
        this.whereParameterEndIndex = whereParameterEndIndex;
    }
}

