/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core.parse.antlr.sql.statement.dml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.shardingsphere.core.parse.antlr.sql.statement.dml.DQLStatement;
import org.apache.shardingsphere.core.parse.antlr.sql.token.OffsetToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.RowCountToken;
import org.apache.shardingsphere.core.parse.antlr.sql.token.SQLToken;
import org.apache.shardingsphere.core.parse.old.parser.context.condition.OrCondition;
import org.apache.shardingsphere.core.parse.old.parser.context.limit.Limit;
import org.apache.shardingsphere.core.parse.old.parser.context.orderby.OrderItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.AggregationDistinctSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.AggregationSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.DistinctSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.SelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.selectitem.StarSelectItem;
import org.apache.shardingsphere.core.parse.old.parser.context.table.Table;
import org.apache.shardingsphere.core.parse.util.SQLUtil;

public final class SelectStatement
extends DQLStatement {
    private boolean containStar;
    private int firstSelectItemStartIndex;
    private int selectListStopIndex;
    private int groupByLastIndex;
    private final Set<SelectItem> items = new LinkedHashSet<SelectItem>();
    private final List<OrderItem> groupByItems = new LinkedList<OrderItem>();
    private final List<OrderItem> orderByItems = new LinkedList<OrderItem>();
    private Limit limit;
    private SelectStatement parentStatement;
    private SelectStatement subqueryStatement;
    private Collection<SelectStatement> subqueryStatements = new LinkedList<SelectStatement>();
    private Collection<OrCondition> subqueryConditions = new LinkedList<OrCondition>();

    public Optional<String> getAlias(String name) {
        if (this.containStar) {
            return Optional.absent();
        }
        String rawName = SQLUtil.getExactlyValue(name);
        for (SelectItem each : this.items) {
            if (SQLUtil.getExactlyExpression(rawName).equalsIgnoreCase(SQLUtil.getExactlyExpression(SQLUtil.getExactlyValue(each.getExpression())))) {
                return each.getAlias();
            }
            if (!rawName.equalsIgnoreCase((String)each.getAlias().orNull())) continue;
            return Optional.of((Object)rawName);
        }
        return Optional.absent();
    }

    public List<AggregationSelectItem> getAggregationSelectItems() {
        LinkedList<AggregationSelectItem> result = new LinkedList<AggregationSelectItem>();
        for (SelectItem each : this.items) {
            if (!(each instanceof AggregationSelectItem)) continue;
            AggregationSelectItem aggregationSelectItem = (AggregationSelectItem)each;
            result.add(aggregationSelectItem);
            result.addAll(aggregationSelectItem.getDerivedAggregationSelectItems());
        }
        return result;
    }

    public Optional<DistinctSelectItem> getDistinctSelectItem() {
        for (SelectItem each : this.items) {
            if (!(each instanceof DistinctSelectItem)) continue;
            return Optional.of((Object)((DistinctSelectItem)each));
        }
        return Optional.absent();
    }

    public List<AggregationDistinctSelectItem> getAggregationDistinctSelectItems() {
        LinkedList<AggregationDistinctSelectItem> result = new LinkedList<AggregationDistinctSelectItem>();
        for (SelectItem each : this.items) {
            if (!(each instanceof AggregationDistinctSelectItem)) continue;
            result.add((AggregationDistinctSelectItem)each);
        }
        return result;
    }

    public boolean hasUnqualifiedStarSelectItem() {
        for (SelectItem each : this.items) {
            if (!(each instanceof StarSelectItem) || ((StarSelectItem)each).getOwner().isPresent()) continue;
            return true;
        }
        return false;
    }

    public Collection<StarSelectItem> getQualifiedStarSelectItems() {
        LinkedList<StarSelectItem> result = new LinkedList<StarSelectItem>();
        for (SelectItem each : this.items) {
            if (!(each instanceof StarSelectItem) || !((StarSelectItem)each).getOwner().isPresent()) continue;
            result.add((StarSelectItem)each);
        }
        return result;
    }

    public Optional<StarSelectItem> findStarSelectItem(String tableNameOrAlias) {
        Optional<Table> table = this.getTables().find(tableNameOrAlias);
        if (!table.isPresent()) {
            return Optional.absent();
        }
        for (SelectItem each : this.items) {
            StarSelectItem starSelectItem;
            if (!(each instanceof StarSelectItem) || !(starSelectItem = (StarSelectItem)each).getOwner().isPresent() || !this.getTables().find((String)starSelectItem.getOwner().get()).equals(table)) continue;
            return Optional.of((Object)starSelectItem);
        }
        return Optional.absent();
    }

    public boolean isSameGroupByAndOrderByItems() {
        return !this.getGroupByItems().isEmpty() && this.getGroupByItems().equals(this.getOrderByItems());
    }

    public void setIndexForItems(Map<String, Integer> columnLabelIndexMap) {
        this.setIndexForAggregationItem(columnLabelIndexMap);
        this.setIndexForOrderItem(columnLabelIndexMap, this.orderByItems);
        this.setIndexForOrderItem(columnLabelIndexMap, this.groupByItems);
    }

    private void setIndexForAggregationItem(Map<String, Integer> columnLabelIndexMap) {
        for (AggregationSelectItem each : this.getAggregationSelectItems()) {
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(each.getColumnLabel()), (String)"Can't find index: %s, please add alias for aggregate selections", (Object[])new Object[]{each});
            each.setIndex(columnLabelIndexMap.get(each.getColumnLabel()));
            for (AggregationSelectItem derived : each.getDerivedAggregationSelectItems()) {
                Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(derived.getColumnLabel()), (String)"Can't find index: %s", (Object[])new Object[]{derived});
                derived.setIndex(columnLabelIndexMap.get(derived.getColumnLabel()));
            }
        }
    }

    private void setIndexForOrderItem(Map<String, Integer> columnLabelIndexMap, List<OrderItem> orderItems) {
        for (OrderItem each : orderItems) {
            if (-1 != each.getIndex()) continue;
            Preconditions.checkState((boolean)columnLabelIndexMap.containsKey(each.getColumnLabel()), (String)"Can't find index: %s", (Object[])new Object[]{each});
            if (!columnLabelIndexMap.containsKey(each.getColumnLabel())) continue;
            each.setIndex(columnLabelIndexMap.get(each.getColumnLabel()));
        }
    }

    public void setSubqueryStatement(SelectStatement subqueryStatement) {
        this.subqueryStatement = subqueryStatement;
        this.setParametersIndex(subqueryStatement.getParametersIndex());
    }

    public boolean containsSubquery() {
        return null != this.subqueryStatement;
    }

    public SelectStatement mergeSubqueryStatement() {
        SelectStatement result = this.processLimitForSubquery();
        this.processItems(result);
        this.processOrderByItems(result);
        result.setParametersIndex(this.getParametersIndex());
        return result;
    }

    private SelectStatement processLimitForSubquery() {
        SelectStatement result = this;
        List<SQLToken> limitSQLTokens = this.getLimitTokens(result);
        Limit limit = result.getLimit();
        while (result.containsSubquery()) {
            result = result.subqueryStatement;
            limitSQLTokens.addAll(this.getLimitTokens(result));
            if (null == result.getLimit()) continue;
            if (null == limit) {
                limit = result.getLimit();
            }
            if (null != result.getLimit().getRowCount()) {
                limit.setRowCount(result.getLimit().getRowCount());
            }
            if (null == result.getLimit().getOffset()) continue;
            limit.setOffset(result.getLimit().getOffset());
        }
        this.resetLimitTokens(result, limitSQLTokens);
        result.setLimit(limit);
        return result;
    }

    private List<SQLToken> getLimitTokens(SelectStatement selectStatement) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (SQLToken each : selectStatement.getSQLTokens()) {
            if (!(each instanceof RowCountToken) && !(each instanceof OffsetToken)) continue;
            result.add(each);
        }
        return result;
    }

    private void resetLimitTokens(SelectStatement selectStatement, List<SQLToken> limitSQLTokens) {
        List<SQLToken> sqlTokens = selectStatement.getSQLTokens();
        Iterator<SQLToken> sqlTokenIterator = sqlTokens.iterator();
        while (sqlTokenIterator.hasNext()) {
            SQLToken each = sqlTokenIterator.next();
            if (!(each instanceof RowCountToken) && !(each instanceof OffsetToken)) continue;
            sqlTokenIterator.remove();
        }
        sqlTokens.addAll(limitSQLTokens);
    }

    private void processItems(SelectStatement subqueryStatement) {
        if (!this.containStar) {
            subqueryStatement.getItems().clear();
            subqueryStatement.getItems().addAll(this.getItems());
        }
    }

    private void processOrderByItems(SelectStatement subqueryStatement) {
        if (!this.containStar) {
            subqueryStatement.getOrderByItems().clear();
            subqueryStatement.getGroupByItems().clear();
        }
    }

    public boolean isContainStar() {
        return this.containStar;
    }

    public int getFirstSelectItemStartIndex() {
        return this.firstSelectItemStartIndex;
    }

    public int getSelectListStopIndex() {
        return this.selectListStopIndex;
    }

    public int getGroupByLastIndex() {
        return this.groupByLastIndex;
    }

    public Set<SelectItem> getItems() {
        return this.items;
    }

    public List<OrderItem> getGroupByItems() {
        return this.groupByItems;
    }

    public List<OrderItem> getOrderByItems() {
        return this.orderByItems;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public SelectStatement getParentStatement() {
        return this.parentStatement;
    }

    public SelectStatement getSubqueryStatement() {
        return this.subqueryStatement;
    }

    public Collection<SelectStatement> getSubqueryStatements() {
        return this.subqueryStatements;
    }

    public Collection<OrCondition> getSubqueryConditions() {
        return this.subqueryConditions;
    }

    public void setContainStar(boolean containStar) {
        this.containStar = containStar;
    }

    public void setFirstSelectItemStartIndex(int firstSelectItemStartIndex) {
        this.firstSelectItemStartIndex = firstSelectItemStartIndex;
    }

    public void setSelectListStopIndex(int selectListStopIndex) {
        this.selectListStopIndex = selectListStopIndex;
    }

    public void setGroupByLastIndex(int groupByLastIndex) {
        this.groupByLastIndex = groupByLastIndex;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public void setParentStatement(SelectStatement parentStatement) {
        this.parentStatement = parentStatement;
    }

    public void setSubqueryStatements(Collection<SelectStatement> subqueryStatements) {
        this.subqueryStatements = subqueryStatements;
    }

    public void setSubqueryConditions(Collection<OrCondition> subqueryConditions) {
        this.subqueryConditions = subqueryConditions;
    }

    @Override
    public String toString() {
        return "SelectStatement(super=" + super.toString() + ", containStar=" + this.isContainStar() + ", firstSelectItemStartIndex=" + this.getFirstSelectItemStartIndex() + ", selectListStopIndex=" + this.getSelectListStopIndex() + ", groupByLastIndex=" + this.getGroupByLastIndex() + ", items=" + this.getItems() + ", groupByItems=" + this.getGroupByItems() + ", orderByItems=" + this.getOrderByItems() + ", limit=" + this.getLimit() + ", subqueryStatement=" + this.getSubqueryStatement() + ", subqueryStatements=" + this.getSubqueryStatements() + ", subqueryConditions=" + this.getSubqueryConditions() + ")";
    }
}

